/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.audio.WaveContainer;
import adams.data.conversion.AbstractConversion;
import com.musicg.wave.Wave;
import com.musicg.wave.extension.Spectrogram;

public class WaveToSpectrogram
extends AbstractConversion {
    private static final long serialVersionUID = -4549516743908263051L;
    protected int m_FFTSampleSize;
    protected int m_OverlapFactor;

    public String globalInfo() {
        return "Generates a spectrogram from the incoming Wave container.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("fft-sample-size", "FFTSampleSize", (Object)1024, (Number)2, null);
        this.m_OptionManager.add("overlap-factor", "overlapFactor", (Object)0, (Number)0, null);
    }

    public void setFFTSampleSize(int value) {
        if (this.getOptionManager().isValid("FFTSampleSize", (Number)value) && Integer.bitCount(value) == 1) {
            this.m_FFTSampleSize = value;
            this.reset();
        }
    }

    public int getFFTSampleSize() {
        return this.m_FFTSampleSize;
    }

    public String FFTSampleSizeTipText() {
        return "The sample size for the fast fourier transformation; must be a power of 2.";
    }

    public void setOverlapFactor(int value) {
        if (this.getOptionManager().isValid("overlapFactor", (Number)value)) {
            this.m_OverlapFactor = value;
            this.reset();
        }
    }

    public int getOverlapFactor() {
        return this.m_OverlapFactor;
    }

    public String overlapFactorTipText() {
        return "The overlap factor (1/factor), eg 4 = 1/4 = 25%; 0 = no overlap.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"FFTSampleSize", (Object)this.m_FFTSampleSize, (String)"sample size: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlapFactor", (Object)(this.m_OverlapFactor == 0 ? "-none-" : "1/" + this.m_OverlapFactor), (String)", overlap factor: ");
        return result;
    }

    public Class accepts() {
        return WaveContainer.class;
    }

    public Class generates() {
        return Spectrogram.class;
    }

    protected Object doConvert() throws Exception {
        return new Spectrogram((Wave)((WaveContainer)this.m_Input).getAudio(), this.m_FFTSampleSize, this.m_OverlapFactor);
    }
}

