/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.audioinfo;

import adams.core.Utils;
import adams.core.base.BaseURL;
import adams.core.io.FileUtils;
import adams.data.audio.WaveContainer;
import adams.flow.transformer.audioinfo.AbstractAudioInfoReader;
import com.musicg.wave.WaveHeader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Wave
extends AbstractAudioInfoReader {
    private static final long serialVersionUID = 568010617982277726L;

    public String globalInfo() {
        return "Outputs information on the incoming Wave data.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, URL.class, BaseURL.class, com.musicg.wave.Wave.class, WaveContainer.class};
    }

    @Override
    protected Map<String, Object> doRead(Object input) throws Exception {
        BufferedInputStream is = null;
        com.musicg.wave.Wave wave = null;
        if (input instanceof String) {
            is = new BufferedInputStream(new FileInputStream((String)input));
        } else if (input instanceof URL) {
            is = new BufferedInputStream(((URL)input).openStream());
        } else if (input instanceof BaseURL) {
            is = new BufferedInputStream(((BaseURL)input).urlValue().openStream());
        } else if (input instanceof com.musicg.wave.Wave) {
            wave = (com.musicg.wave.Wave)input;
        } else if (input instanceof WaveContainer) {
            wave = (com.musicg.wave.Wave)((WaveContainer)input).getAudio();
        }
        if (is != null) {
            wave = new com.musicg.wave.Wave((InputStream)is);
        }
        if (wave == null) {
            throw new IllegalStateException("Unhandled input data: " + Utils.classToString((Object)input));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        WaveHeader header = wave.getWaveHeader();
        result.put("chunkId", header.getChunkId());
        result.put("chunkSize", header.getChunkSize());
        result.put("format", header.getFormat());
        result.put("subChunk1Id", header.getSubChunk1Id());
        result.put("subChunk1Size", header.getSubChunk1Size());
        result.put("audioFormat", header.getAudioFormat());
        result.put("channels", header.getChannels());
        result.put("sampleRate", header.getSampleRate());
        result.put("byteRate", header.getByteRate());
        result.put("blockAlign", header.getBlockAlign());
        result.put("bitsPerSample", header.getBitsPerSample());
        result.put("subChunk2Id", header.getSubChunk2Id());
        result.put("subChunk2Size", header.getSubChunk2Size());
        result.put("lengthInSeconds", Float.valueOf((float)header.getSubChunk2Size() / (float)header.getByteRate()));
        if (is != null) {
            FileUtils.closeQuietly((InputStream)is);
        }
        return result;
    }
}

