/*
 * Decompiled with CFR 0.152.
 */
package adams.data.wavefilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.audio.WaveContainer;
import adams.data.wavefilter.AbstractWaveFilter;
import com.musicg.dsp.Resampler;
import com.musicg.wave.Wave;
import com.musicg.wave.WaveHeader;

public class Resample
extends AbstractWaveFilter {
    private static final long serialVersionUID = 2319957467336388607L;
    protected int m_TargetSampleRate;

    public String globalInfo() {
        return "Adjusts the data to use the target sample rate.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("target-sample-rate", "targetSampleRate", (Object)44100, (Number)1, null);
    }

    public void setTargetSampleRate(int value) {
        this.m_TargetSampleRate = value;
        this.reset();
    }

    public int getTargetSampleRate() {
        return this.m_TargetSampleRate;
    }

    public String targetSampleRateTipText() {
        return "The new sample rate to use.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"targetSampleRate", (Object)this.m_TargetSampleRate, (String)"sample rate: ");
    }

    @Override
    protected WaveContainer processData(WaveContainer data) {
        WaveHeader headerOld = ((Wave)data.getAudio()).getWaveHeader();
        byte[] bytesOld = ((Wave)data.getAudio()).getBytes();
        Resampler resampler = new Resampler();
        byte[] bytesNew = resampler.reSample(bytesOld, headerOld.getBitsPerSample(), headerOld.getSampleRate(), this.m_TargetSampleRate);
        WaveHeader headerNew = headerOld.clone();
        headerNew.setSampleRate(this.m_TargetSampleRate);
        Wave waveNew = new Wave(headerNew, bytesNew);
        WaveContainer result = (WaveContainer)data.getHeader();
        result.setAudio(waveNew);
        return result;
    }
}

