/*
 * Decompiled with CFR 0.152.
 */
package adams.data.wavefilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.InPlaceProcessing;
import adams.data.audio.WaveContainer;
import adams.data.wavefilter.AbstractWaveFilter;
import adams.data.wavefilter.WaveIndexingType;
import com.musicg.wave.Wave;

public class Trim
extends AbstractWaveFilter
implements InPlaceProcessing {
    private static final long serialVersionUID = 2319957467336388607L;
    protected WaveIndexingType m_Type;
    protected double m_Left;
    protected double m_Right;
    protected boolean m_NoCopy;

    public String globalInfo() {
        return "Trims the Wave object left and/or right, using either sample number of time in seconds.\nOnly works if 'subChunk2Id' is 'data' not 'LIST'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)WaveIndexingType.SAMPLES);
        this.m_OptionManager.add("left", "left", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("right", "right", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("no-copy", "noCopy", (Object)false);
    }

    public void setType(WaveIndexingType value) {
        this.m_Type = value;
        this.reset();
    }

    public WaveIndexingType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "How to interpret the left/right values.";
    }

    public void setLeft(double value) {
        this.m_Left = value;
        this.reset();
    }

    public double getLeft() {
        return this.m_Left;
    }

    public String leftTipText() {
        return "The starting point of the trimming.";
    }

    public void setRight(double value) {
        this.m_Right = value;
        this.reset();
    }

    public double getRight() {
        return this.m_Right;
    }

    public String rightTipText() {
        return "The end point of the trimming; ignored if 0.";
    }

    public void setNoCopy(boolean value) {
        this.m_NoCopy = value;
        this.reset();
    }

    public boolean getNoCopy() {
        return this.m_NoCopy;
    }

    public String noCopyTipText() {
        return "If enabled, no copy of the Wave is created before trimming it.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"left", (Object)this.m_Left, (String)", left: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"right", (Object)this.m_Right, (String)", right: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no-copy", (String)", ");
        return result;
    }

    @Override
    protected WaveContainer processData(WaveContainer data) {
        WaveContainer result = !this.m_NoCopy ? (WaveContainer)data.getClone() : data;
        switch (this.m_Type) {
            case SAMPLES: {
                ((Wave)result.getAudio()).trim((int)this.m_Left, (int)this.m_Right);
                break;
            }
            case SECONDS: {
                ((Wave)result.getAudio()).trim(this.m_Left, this.m_Right);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled trim type: " + (Object)((Object)this.m_Type));
            }
        }
        return result;
    }
}

