/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.flow.sink.AbstractSink;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javazoom.jl.player.Player;

public class AudioPlayback
extends AbstractSink
implements LineListener {
    private static final long serialVersionUID = -1056104741820669736L;
    protected boolean m_PlaybackFinished;

    public String globalInfo() {
        return "Plays back an audio file (MP3/WAV).";
    }

    public Class[] accepts() {
        return new Class[]{String.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result;
        block12: {
            Line clip;
            PlaceholderFile file;
            block13: {
                result = null;
                file = new PlaceholderFile((String)this.m_InputToken.getPayload(String.class));
                clip = null;
                this.m_PlaybackFinished = false;
                if (!file.getName().toLowerCase().endsWith(".mp3")) break block13;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file.getAbsoluteFile());
                    Player player = new Player((InputStream)fis);
                    player.play();
                    while (!(this.isStopped() || this.m_PlaybackFinished || player.isComplete())) {
                        Utils.wait((LoggingSupporter)this, (int)1000, (int)100);
                    }
                }
                catch (Exception e) {
                    try {
                        result = this.handleException("Failed to playback file: " + file, e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    FileUtils.closeQuietly((InputStream)fis);
                    break block12;
                }
                FileUtils.closeQuietly((InputStream)fis);
                break block12;
            }
            try {
                AudioInputStream ais = AudioSystem.getAudioInputStream(file.getAbsoluteFile());
                AudioFormat format = ais.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                clip = (Clip)AudioSystem.getLine(info);
                clip.addLineListener(this);
                clip.open(ais);
                clip.start();
                while (!this.isStopped() && !this.m_PlaybackFinished) {
                    Utils.wait((LoggingSupporter)this, (int)1000, (int)100);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to playback file: " + file, e);
            }
            finally {
                if (clip != null) {
                    clip.removeLineListener(this);
                    clip.close();
                }
            }
        }
        return result;
    }

    @Override
    public void update(LineEvent event) {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Line event: " + event.getType());
        }
        if (event.getType() == LineEvent.Type.STOP) {
            this.m_PlaybackFinished = true;
        }
    }
}

