/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.FileWriter;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractSink;
import java.io.File;
import javazoom.jl.converter.Converter;

public class MP3ToWave
extends AbstractSink
implements FileWriter {
    private static final long serialVersionUID = 8441244538728070082L;
    protected PlaceholderFile m_OutputFile;

    public String globalInfo() {
        return "Converts the incoming MP3 file into a Wave file (the output file).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "outputFile", (Object)this.getDefaultOutputFile());
    }

    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile(".");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputFile", (Object)this.m_OutputFile);
    }

    public void setOutputFile(PlaceholderFile value) {
        this.m_OutputFile = value;
        this.reset();
    }

    public PlaceholderFile getOutputFile() {
        return this.m_OutputFile;
    }

    public String outputFileTipText() {
        return "The name of the Wave output file.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    protected String doExecute() {
        String result = null;
        String filename = this.m_InputToken.hasPayload(File.class) ? ((File)this.m_InputToken.getPayload(File.class)).getAbsolutePath() : (String)this.m_InputToken.getPayload(String.class);
        try {
            Converter converter = new Converter();
            converter.convert(new PlaceholderFile(filename).getAbsolutePath(), this.m_OutputFile.getAbsolutePath());
        }
        catch (Exception e) {
            result = this.handleException("Failed to convert '" + filename + "' to '" + this.m_OutputFile + "'!", e);
        }
        return result;
    }
}

