/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.audio.WaveContainer;
import adams.data.wavefilter.AbstractWaveFilter;
import adams.data.wavefilter.PassThrough;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class WaveFilter
extends AbstractTransformer {
    private static final long serialVersionUID = -1998955116780561587L;
    protected AbstractWaveFilter m_Filter;

    public String globalInfo() {
        return "Applies the filter to the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
    }

    public void setFilter(AbstractWaveFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractWaveFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to apply to the data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)((Object)this.m_Filter), (String)"filter: ");
    }

    public Class[] accepts() {
        return new Class[]{WaveContainer.class};
    }

    public Class[] generates() {
        return new Class[]{WaveContainer.class};
    }

    protected String doExecute() {
        String result = null;
        WaveContainer data = (WaveContainer)this.m_InputToken.getPayload(WaveContainer.class);
        WaveContainer filtered = null;
        try {
            filtered = this.m_Filter.filter(data);
        }
        catch (Exception e) {
            result = this.handleException("Failed to filter data: " + data, e);
        }
        if (filtered != null) {
            this.m_OutputToken = new Token((Object)filtered);
        }
        return result;
    }
}

