/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.audioannotator;

import adams.core.TimeMsec;
import adams.gui.audio.AudioPlaybackPanel;
import adams.gui.tools.audioannotator.TickEvent;
import adams.gui.tools.audioannotator.TickListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Ticker {
    protected ScheduledExecutorService m_Scheduler = Executors.newScheduledThreadPool(1);
    protected List<ScheduledFuture<?>> m_Handlers = new ArrayList();
    protected HashMap<Long, Tick> m_Ticks = new HashMap();
    protected AudioPlaybackPanel m_AudioPlayer;

    public Ticker(AudioPlaybackPanel player) {
        this.m_AudioPlayer = player;
    }

    public void addListener(TickListener tickListener) {
        Long key = tickListener.getInterval();
        if (this.m_Ticks.containsKey(key)) {
            this.m_Ticks.get(key).addListener(tickListener);
        } else {
            Tick newTick = new Tick();
            newTick.addListener(tickListener);
            this.m_Ticks.put(key, newTick);
            this.m_Handlers.add(this.m_Scheduler.scheduleAtFixedRate(newTick, 0L, key, TimeUnit.MILLISECONDS));
        }
    }

    public void removeAll() {
        for (ScheduledFuture<?> future : this.m_Handlers) {
            future.cancel(false);
        }
        this.m_Handlers = new ArrayList();
        this.m_Ticks = new HashMap();
    }

    private class Tick
    implements Runnable {
        private List<TickListener> m_Listeners = new ArrayList<TickListener>();

        Tick() {
        }

        @Override
        public void run() {
            this.notifyTickListeners();
        }

        private void notifyTickListeners() {
            long msec = Ticker.this.m_AudioPlayer.getTimestamp();
            if (msec == -1L || !Ticker.this.m_AudioPlayer.isPlaying()) {
                return;
            }
            TimeMsec timeStamp = new TimeMsec(msec);
            TickEvent tickEvent = new TickEvent(timeStamp);
            for (TickListener listener : this.m_Listeners) {
                listener.tickHappened(tickEvent);
            }
        }

        public void addListener(TickListener tickListener) {
            this.m_Listeners.add(tickListener);
        }
    }
}

