/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagemagick;

import adams.core.io.FileUtils;
import adams.env.Environment;
import java.io.File;

public class DCRawHelper {
    public static final String ENV_PATH = "DCRAW_TOOLPATH";
    protected static Boolean m_DcrawPresent;

    public static boolean isDcrawAvailable() {
        if (m_DcrawPresent == null) {
            String exec = FileUtils.fixExecutable((String)"dcraw");
            String path = System.getenv(ENV_PATH);
            if (path != null) {
                exec = path + File.separator + exec;
            }
            try {
                Runtime.getRuntime().exec(new String[]{exec});
                m_DcrawPresent = true;
            }
            catch (Exception e) {
                System.err.println("Failed to execute '" + exec + "':");
                e.printStackTrace();
                m_DcrawPresent = false;
            }
        }
        return m_DcrawPresent;
    }

    public static String getMissingDcrawErrorMessage() {
        return "dcraw not installed or DCRAW_TOOLPATH environment variable not pointing to installation!";
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        System.out.println("Tool availability:");
        System.out.println("- dcraw? " + DCRawHelper.isDcrawAvailable());
    }
}

