/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.data.imagemagick.UFRawHelper;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import java.awt.image.BufferedImage;
import java.io.File;

public class UfrawImageReader
extends AbstractImageReader<BufferedImageContainer> {
    private static final long serialVersionUID = 5347100846354068540L;

    public String globalInfo() {
        return "UFRaw image reader for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ") + "\n" + "For more information see:\n" + "http://ufraw.sourceforge.net/\n" + (UFRawHelper.isUfrawAvailable() ? "" : "\n" + UFRawHelper.getMissingUfrawErrorMessage());
    }

    public String getFormatDescription() {
        return "UFraw";
    }

    public String[] getFormatExtensions() {
        return new String[]{"3fr", "arw", "bay", "bmq", "cine", "cr2", "crw", "cs1", "dc2", "dcr", "dng", "erf", "fff", "hdr", "ia", "jpg", "k25", "kc2", "kdc", "mdc", "mef", "mos", "mrw", "nef", "nrw", "orf", "pef", "pxn", "qtk", "raf", "raw", "rdc", "rw2", "sr2", "srf", "sti", "tif", "x3f"};
    }

    public AbstractImageWriter getCorrespondingWriter() {
        return null;
    }

    public boolean isAvailable() {
        return UFRawHelper.isUfrawAvailable();
    }

    protected BufferedImageContainer doRead(PlaceholderFile file) {
        BufferedImageContainer result = null;
        BufferedImage image = UFRawHelper.read((File)file);
        if (image != null) {
            result = new BufferedImageContainer();
            result.setImage((Object)image);
        }
        return result;
    }
}

