/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import adams.data.boofcv.transformer.PassThrough;
import adams.data.image.AbstractImageContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.Arrays;

public class BoofCVTransformer
extends AbstractArrayProvider
implements ProvenanceSupporter {
    private static final long serialVersionUID = 3690378527551302472L;
    protected AbstractBoofCVTransformer m_TransformAlgorithm;

    public String globalInfo() {
        return "Applies a BoofCV transformation to the incoming image and outputs the generated image(s).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformAlgorithm", (Object)new PassThrough());
    }

    public String outputArrayTipText() {
        return "Whether to output the images as an array or one-by-one.";
    }

    public void setTransformAlgorithm(AbstractBoofCVTransformer value) {
        this.m_TransformAlgorithm = value;
        this.reset();
    }

    public AbstractBoofCVTransformer getTransformAlgorithm() {
        return this.m_TransformAlgorithm;
    }

    public String transformAlgorithmTipText() {
        return "The transformer to use for transformering the image.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"transformAlgorithm", (Object)((Object)this.m_TransformAlgorithm));
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)(this.m_OutputArray ? "as array" : ""), (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    protected Class getItemClass() {
        return BoofCVImageContainer.class;
    }

    protected String doExecute() {
        String result = null;
        try {
            BoofCVImageContainer img = BoofCVHelper.toBoofCVImageContainer((AbstractImageContainer)this.m_InputToken.getPayload());
            this.m_Queue.clear();
            this.m_Queue.addAll(Arrays.asList(this.m_TransformAlgorithm.transform(img)));
        }
        catch (Exception e) {
            result = this.handleException("Failed to transform image: ", e);
        }
        return result;
    }

    public Token output() {
        Token result = super.output();
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

