/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.Notes;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.locateobjects.PassThrough;
import java.awt.image.BufferedImage;

public class LocateObjects
extends AbstractArrayProvider {
    private static final long serialVersionUID = 2180810317840558011L;
    public static final String BACKUP_QUEUE = "queue";
    public static final String FIELD_X = "X";
    public static final String FIELD_Y = "Y";
    public static final String FIELD_WIDTH = "Width";
    public static final String FIELD_HEIGHT = "Height";
    protected AbstractObjectLocator m_Locator;
    protected boolean m_GenerateReport;
    protected String m_Prefix;

    public String globalInfo() {
        return "Locates objects in an image and forwards an image per located object, cropped around the object.\nIt is also possible to simply annotate the image by storing the locations of the located objects in the report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("locator", "locator", (Object)new PassThrough());
        this.m_OptionManager.add("generate-report", "generateReport", (Object)false);
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
    }

    public String outputArrayTipText() {
        return "Outputs the images either one by one or as array.";
    }

    public void setLocator(AbstractObjectLocator value) {
        this.m_Locator = value;
        this.reset();
    }

    public AbstractObjectLocator getLocator() {
        return this.m_Locator;
    }

    public String locatorTipText() {
        return "The algorithm for locating the objects.";
    }

    public void setGenerateReport(boolean value) {
        this.m_GenerateReport = value;
        this.reset();
    }

    public boolean getGenerateReport() {
        return this.m_GenerateReport;
    }

    public String generateReportTipText() {
        return "If enabled, an annotated image containing a report with all the locations is generated instead of separate image objects.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix to use when generating a report.";
    }

    public String getQuickInfo() {
        String result = "locator: ";
        String variable = this.getOptionManager().getVariableForProperty("locator");
        result = variable != null ? result + variable : result + ((Object)((Object)this.m_Locator)).getClass().getSimpleName();
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, BufferedImage.class};
    }

    protected Class getItemClass() {
        return BufferedImageContainer.class;
    }

    protected String doExecute() {
        Report report;
        Notes notes;
        BufferedImage image;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
            AbstractImageContainer contIn = (AbstractImageContainer)this.m_InputToken.getPayload();
            image = contIn.toBufferedImage();
            notes = contIn.getNotes().getClone();
            report = contIn.getReport().getClone();
        } else {
            image = (BufferedImage)this.m_InputToken.getPayload();
            notes = null;
            report = new Report();
        }
        if (this.isHeadless()) {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage((Object)image);
            if (notes != null) {
                cont.setNotes(notes);
            }
            this.m_OutputToken = new Token((Object)cont);
            return result;
        }
        try {
            LocatedObjects objects = this.m_GenerateReport ? this.m_Locator.annotate(image) : this.m_Locator.locate(image);
            if (this.m_Locator.hasErrors()) {
                if (notes == null) {
                    notes = new Notes();
                }
                for (String error : this.m_Locator.getErrors()) {
                    notes.addError(((Object)((Object)this)).getClass(), error);
                }
            }
            if (this.m_Locator.hasWarnings()) {
                if (notes == null) {
                    notes = new Notes();
                }
                for (String warning : this.m_Locator.getWarnings()) {
                    notes.addWarning(((Object)((Object)this)).getClass(), warning);
                }
            }
            this.m_Queue.clear();
            if (this.m_GenerateReport) {
                BufferedImageContainer cont = new BufferedImageContainer();
                cont.setImage((Object)image);
                cont.getReport().mergeWith(objects.toReport(this.m_Prefix));
                this.m_Queue.add(cont);
            } else {
                for (LocatedObject object : objects) {
                    BufferedImageContainer cont = new BufferedImageContainer();
                    cont.setImage((Object)object.getImage());
                    cont.getNotes().mergeWith(notes);
                    Report reportNew = new Report();
                    reportNew.setNumericValue(FIELD_X, (double)object.getX());
                    reportNew.setNumericValue(FIELD_Y, (double)object.getY());
                    reportNew.setNumericValue(FIELD_WIDTH, (double)object.getWidth());
                    reportNew.setNumericValue(FIELD_HEIGHT, (double)object.getHeight());
                    cont.setReport(reportNew);
                    cont.getReport().mergeWith(report);
                    this.m_Queue.add(cont);
                }
            }
            this.m_Locator.cleanUp();
        }
        catch (Exception e) {
            result = this.handleException("Failed to locate objects!", e);
        }
        return result;
    }

    public void stopExecution() {
        this.m_Locator.stopExecution();
        super.stopExecution();
    }
}

