/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pixelselector;

import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.flow.transformer.pixelselector.PixelSelectorPanel;
import adams.gui.action.AbstractBaseAction;
import java.awt.Point;
import java.awt.event.ActionEvent;

public abstract class AbstractPixelSelectorAction
extends AbstractBaseAction
implements OptionHandler {
    private static final long serialVersionUID = -6674327571331925321L;
    public static final String MOUSE_POSITION = "Mouse position";
    public static final String PIXEL_POSITION = "Pixel position";
    public static final String PANEL = "Panel";
    protected OptionManager m_OptionManager;

    public AbstractPixelSelectorAction() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
        this.finishInit();
    }

    public abstract String globalInfo();

    protected void initialize() {
        this.setName(this.getTitle());
    }

    protected abstract String getTitle();

    protected void reset() {
        this.setMousePosition(null);
    }

    protected OptionManager newOptionManager() {
        return new OptionManager((OptionHandler)this);
    }

    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
    }

    protected void finishInit() {
    }

    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    public void destroy() {
        this.cleanUpOptions();
    }

    public String toString() {
        return OptionUtils.getCommandLine((Object)((Object)this));
    }

    public String toCommandLine() {
        return OptionUtils.getCommandLine((Object)((Object)this));
    }

    public void setMousePosition(Point value) {
        this.putValue(MOUSE_POSITION, value);
    }

    public boolean hasMousePosition() {
        return this.getValue(MOUSE_POSITION) != null;
    }

    public Point getMousePosition() {
        return (Point)this.getValue(MOUSE_POSITION);
    }

    public void setPixelPosition(Point value) {
        this.putValue(PIXEL_POSITION, value);
    }

    public boolean hasPixelPosition() {
        return this.getValue(PIXEL_POSITION) != null;
    }

    public Point getPixelPosition() {
        return (Point)this.getValue(PIXEL_POSITION);
    }

    public void setPanel(PixelSelectorPanel value) {
        this.putValue(PANEL, value);
    }

    public boolean hasPanel() {
        return this.getValue(PANEL) != null;
    }

    public PixelSelectorPanel getPanel() {
        return (PixelSelectorPanel)this.getValue(PANEL);
    }

    protected abstract boolean doProcessAction(ActionEvent var1);

    protected void doActionPerformed(ActionEvent e) {
        if (!this.hasPanel() || this.getPanel().getImage() == null) {
            return;
        }
        if (this.doProcessAction(e) && this.hasPanel()) {
            this.getPanel().update();
        }
    }

    public String check() {
        return null;
    }
}

