/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.clustering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.semanticmetadata.lire.clustering.Cluster;
import net.semanticmetadata.lire.clustering.Image;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.utils.StatsUtils;

public class KMeans {
    protected List<Image> images = new LinkedList<Image>();
    protected int countAllFeatures = 0;
    protected int numClusters = 256;
    protected ArrayList<double[]> features = null;
    protected Cluster[] clusters = null;
    protected HashMap<double[], Integer> featureIndex = null;

    public KMeans() {
    }

    public KMeans(int numClusters) {
        this.numClusters = numClusters;
    }

    public void addImage(String identifier, List<double[]> features) {
        this.images.add(new Image(identifier, features));
        this.countAllFeatures += features.size();
    }

    public int getFeatureCount() {
        return this.countAllFeatures;
    }

    public void init() {
        this.features = new ArrayList(this.countAllFeatures);
        for (Image image : this.images) {
            if (image.features.size() > 0) {
                for (double[] histogram : image.features) {
                    if (this.hasNaNs(histogram)) continue;
                    this.features.add(histogram);
                }
                continue;
            }
            System.err.println("Image with no features: " + image.identifier);
        }
        if (this.images.size() < 500) {
            System.err.println("WARNING: Please note that this approach has been implemented for big data and *a lot of images*. You might not get appropriate results with a small number of images employed for constructing the visual vocabulary.");
        }
        if (this.features.size() < this.numClusters * 2) {
            System.err.println("WARNING: Please note that the number of local features, in this case " + this.features.size() + ", is" + "smaller than the recommended minimum number, which is two times the number of visual words, in your case 2*" + this.numClusters + ". Please adapt your data and either use images with more local features or more images for creating the visual vocabulary.");
        }
        if (this.features.size() < this.numClusters + 1) {
            System.err.println("CRITICAL: The number of features is smaller than the number of clusters. This cannot work as there has to be at least one feature per cluster. Aborting process now.");
            System.out.println("images: " + this.images.size());
            System.out.println("features: " + this.features.size());
            System.out.println("clusters: " + this.numClusters);
            System.exit(1);
        }
        this.clusters = new Cluster[this.numClusters];
        Set<Integer> medians = this.selectInitialMedians(this.numClusters);
        Iterator<Integer> mediansIterator = medians.iterator();
        for (int i = 0; i < this.clusters.length; ++i) {
            this.clusters[i] = new Cluster();
            double[] descriptor = this.features.get(mediansIterator.next());
            System.arraycopy(descriptor, 0, this.clusters[i].mean, 0, descriptor.length);
        }
    }

    protected Set<Integer> selectInitialMedians(int numClusters) {
        return StatsUtils.drawSample(numClusters, this.features.size());
    }

    public double clusteringStep() {
        for (int i = 0; i < this.clusters.length; ++i) {
            this.clusters[i].members.clear();
        }
        this.reOrganizeFeatures();
        this.recomputeMeans();
        return this.overallStress();
    }

    protected boolean hasNaNs(double[] histogram) {
        boolean hasNaNs = false;
        for (int i = 0; i < histogram.length; ++i) {
            if (!Double.isNaN(histogram[i])) continue;
            hasNaNs = true;
            break;
        }
        if (hasNaNs) {
            System.err.println("Found a NaN in init");
            for (int j = 0; j < histogram.length; ++j) {
                double v = histogram[j];
                System.out.print(v + ", ");
            }
            System.out.println("");
        }
        return hasNaNs;
    }

    protected void reOrganizeFeatures() {
        for (int k = 0; k < this.features.size(); ++k) {
            double[] f = this.features.get(k);
            Cluster best = this.clusters[0];
            double minDistance = this.clusters[0].getDistance(f);
            for (int i = 1; i < this.clusters.length; ++i) {
                double v = this.clusters[i].getDistance(f);
                if (!(minDistance > v)) continue;
                best = this.clusters[i];
                minDistance = v;
            }
            best.members.add(k);
        }
    }

    protected void recomputeMeans() {
        int length = this.features.get(0).length;
        for (Cluster cluster : this.clusters) {
            double[] mean = cluster.mean;
            for (int j = 0; j < length; ++j) {
                mean[j] = 0.0;
                for (Integer member : cluster.members) {
                    int n = j;
                    mean[n] = mean[n] + this.features.get(member)[j];
                }
                if (cluster.members.size() <= 1) continue;
                mean[j] = mean[j] / (double)cluster.members.size();
            }
        }
    }

    protected double overallStress() {
        double v = 0.0;
        int length = this.features.get(0).length;
        for (int i = 0; i < this.clusters.length; ++i) {
            for (Integer member : this.clusters[i].members) {
                float tmpStress = 0.0f;
                for (int j = 0; j < length; ++j) {
                    tmpStress = (float)((double)tmpStress + Math.abs(this.clusters[i].mean[j] - this.features.get(member)[j]));
                }
                v += (double)tmpStress;
            }
        }
        return v;
    }

    public Cluster[] getClusters() {
        return this.clusters;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public void setNumClusters(int numClusters) {
        this.numClusters = numClusters;
    }

    private HashMap<double[], Integer> createIndex() {
        this.featureIndex = new HashMap(this.features.size());
        for (int i = 0; i < this.clusters.length; ++i) {
            Cluster cluster = this.clusters[i];
            for (int fid : cluster.members) {
                this.featureIndex.put(this.features.get(fid), i);
            }
        }
        return this.featureIndex;
    }

    public int getClusterOfFeature(Histogram f) {
        if (this.featureIndex == null) {
            this.createIndex();
        }
        return this.featureIndex.get(f);
    }
}

