/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.WritableRaster;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class Gabor
implements LireFeature {
    private static final double U_H = 0.4;
    private static final double U_L = 0.05;
    private static final int S = 4;
    private static final int T = 4;
    private static final int M = 5;
    private static final int N = 6;
    private static final int MAX_IMG_HEIGHT = 64;
    private static final double A;
    private static double[] theta;
    private static double[] modulationFrequency;
    private static double[] sigma_x;
    private static double[] sigma_y;
    private static double[][][][][] selfSimilarGaborWavelets;
    private static final double LOG2;
    private double[][][][][] gaborWavelet = null;
    private double[] histogram;

    public double getDistance(double[] targetFeatureVector, double[] queryFeatureVector) {
        double distance = 0.0;
        for (int m = 0; m < 5; ++m) {
            for (int n = 0; n < 6; ++n) {
                distance += Math.sqrt(Math.pow(queryFeatureVector[m * 2 * 6 + n * 2] - targetFeatureVector[m * 2 * 6 + n * 2], 2.0) + Math.pow(queryFeatureVector[m * 2 * 6 + n * 2 + 1] - targetFeatureVector[m * 2 * 6 + n * 2 + 1], 2.0));
            }
        }
        return distance;
    }

    public double[] getNormalizedFeature(BufferedImage image) {
        return this.normalize(this.getFeature(image));
    }

    public double[] normalize(double[] featureVector) {
        int n;
        int dominantOrientation = 0;
        double orientationVectorSum = 0.0;
        double orientationVectorSum2 = 0.0;
        for (int m = 0; m < 5; ++m) {
            for (int n2 = 0; n2 < 6; ++n2) {
                orientationVectorSum2 += Math.sqrt(Math.pow(featureVector[m * 2 * 6 + n2 * 2], 2.0) + Math.pow(featureVector[m * 2 * 6 + n2 * 2 + 1], 2.0));
            }
            if (!(orientationVectorSum2 > orientationVectorSum)) continue;
            orientationVectorSum = orientationVectorSum2;
            dominantOrientation = m;
        }
        double[] normalizedFeatureVector = new double[featureVector.length];
        int m = dominantOrientation;
        int k = 0;
        while (m < 5) {
            for (n = 0; n < 6; ++n) {
                normalizedFeatureVector[k * 2 * 6 + n * 2] = featureVector[m * 2 * 6 + n * 2];
                normalizedFeatureVector[k * 2 * 6 + n * 2 + 1] = featureVector[m * 2 * 6 + n * 2 + 1];
            }
            ++m;
            ++k;
        }
        m = 0;
        k = 5 - dominantOrientation;
        while (m < dominantOrientation) {
            for (n = 0; n < 6; ++n) {
                normalizedFeatureVector[k * 2 * 6 + n * 2] = featureVector[m * 2 * 6 + n * 2];
                normalizedFeatureVector[k * 2 * 6 + n * 2 + 1] = featureVector[m * 2 * 6 + n * 2 + 1];
            }
            ++m;
            ++k;
        }
        return normalizedFeatureVector;
    }

    public BufferedImage grayscale(BufferedImage source) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return op.filter(source, null);
    }

    public double[] getFeature(BufferedImage image) {
        image = ImageUtils.scaleImage(image, 64);
        WritableRaster imageRaster = image.getRaster();
        int[][] grayLevel = new int[imageRaster.getWidth()][imageRaster.getHeight()];
        int[] tmp = new int[3];
        for (int i = 0; i < imageRaster.getWidth(); ++i) {
            for (int j = 0; j < imageRaster.getHeight(); ++j) {
                grayLevel[i][j] = imageRaster.getPixel(i, j, tmp)[0];
            }
        }
        double[] featureVector = new double[60];
        double[][] magnitudes = this.computeMagnitudes(grayLevel);
        int imageSize = image.getWidth() * image.getHeight();
        double[][] magnitudesForVariance = new double[5][6];
        if (this.gaborWavelet == null) {
            this.precomputeGaborWavelet(grayLevel);
        }
        for (int m = 0; m < 5; ++m) {
            for (int n = 0; n < 6; ++n) {
                featureVector[m * 2 * 6 + n * 2] = magnitudes[m][n] / (double)imageSize;
                for (int i = 0; i < magnitudesForVariance.length; ++i) {
                    for (int j = 0; j < magnitudesForVariance[0].length; ++j) {
                        magnitudesForVariance[i][j] = 0.0;
                    }
                }
                for (int x = 4; x < image.getWidth(); ++x) {
                    for (int y = 4; y < image.getHeight(); ++y) {
                        double[] dArray = magnitudesForVariance[m];
                        int n2 = n;
                        dArray[n2] = dArray[n2] + Math.pow(Math.sqrt(Math.pow(this.gaborWavelet[x - 4][y - 4][m][n][0], 2.0) + Math.pow(this.gaborWavelet[x - 4][y - 4][m][n][1], 2.0)) - featureVector[m * 2 * 6 + n * 2], 2.0);
                    }
                }
                featureVector[m * 2 * 6 + n * 2 + 1] = Math.sqrt(magnitudesForVariance[m][n]) / (double)imageSize;
            }
        }
        this.gaborWavelet = null;
        return featureVector;
    }

    private void precomputeGaborWavelet(int[][] image) {
        this.gaborWavelet = new double[image.length - 4][image[0].length - 4][5][6][2];
        for (int m = 0; m < 5; ++m) {
            for (int n = 0; n < 6; ++n) {
                for (int x = 4; x < image.length; ++x) {
                    for (int y = 4; y < image[0].length; ++y) {
                        double[] gaborWavelet = this.gaborWavelet(image, x, y, m, n);
                        this.gaborWavelet[x - 4][y - 4][m][n][0] = gaborWavelet[0];
                        this.gaborWavelet[x - 4][y - 4][m][n][1] = gaborWavelet[1];
                    }
                }
            }
        }
    }

    private double[][] computeMagnitudes(int[][] image) {
        double[][] magnitudes = new double[5][6];
        for (int i = 0; i < magnitudes.length; ++i) {
            for (int j = 0; j < magnitudes[0].length; ++j) {
                magnitudes[i][j] = 0.0;
            }
        }
        if (this.gaborWavelet == null) {
            this.precomputeGaborWavelet(image);
        }
        for (int m = 0; m < 5; ++m) {
            for (int n = 0; n < 6; ++n) {
                for (int x = 4; x < image.length; ++x) {
                    for (int y = 4; y < image[0].length; ++y) {
                        double[] dArray = magnitudes[m];
                        int n2 = n;
                        dArray[n2] = dArray[n2] + Math.sqrt(Math.pow(this.gaborWavelet[x - 4][y - 4][m][n][0], 2.0) + Math.pow(this.gaborWavelet[x - 4][y - 4][m][n][1], 2.0));
                    }
                }
            }
        }
        return magnitudes;
    }

    private double[] gaborWavelet(int[][] img, int x, int y, int m, int n) {
        double re = 0.0;
        double im = 0.0;
        for (int s = 0; s < 4; ++s) {
            for (int t = 0; t < 4; ++t) {
                re += (double)img[x][y] * selfSimilarGaborWavelets[s][t][m][n][0];
                im += (double)img[x][y] * -selfSimilarGaborWavelets[s][t][m][n][1];
            }
        }
        return new double[]{re, im};
    }

    private double[] computeMotherWavelet(double x, double y, int m, int n) {
        return new double[]{1.0 / (Math.PI * 2 * sigma_x[m] * sigma_y[m]) * Math.exp(0.0 * (Math.pow(x, 2.0) / Math.pow(sigma_x[m], 2.0) + Math.pow(y, 2.0) / Math.pow(sigma_y[m], 2.0))) * Math.cos(Math.PI * 2 * modulationFrequency[m] * x), 1.0 / (Math.PI * 2 * sigma_x[m] * sigma_y[m]) * Math.exp(0.0 * (Math.pow(x, 2.0) / Math.pow(sigma_x[m], 2.0) + Math.pow(y, 2.0) / Math.pow(sigma_y[m], 2.0))) * Math.sin(Math.PI * 2 * modulationFrequency[m] * x)};
    }

    private double x_tilde(int x, int y, int m, int n) {
        return Math.pow(A, -m) * ((double)x * Math.cos(theta[n]) + (double)y * Math.sin(theta[n]));
    }

    private double y_tilde(int x, int y, int m, int n) {
        return Math.pow(A, -m) * ((double)(-x) * Math.sin(theta[n] + (double)y * Math.cos(theta[n])));
    }

    private double[] selfSimilarGaborWavelet(int x, int y, int m, int n) {
        double[] motherWavelet = this.computeMotherWavelet(this.x_tilde(x, y, m, n), this.y_tilde(x, y, m, n), m, n);
        return new double[]{Math.pow(A, -m) * motherWavelet[0], Math.pow(A, -m) * motherWavelet[1]};
    }

    @Override
    public void extract(BufferedImage bimg) {
        this.histogram = this.getNormalizedFeature(bimg);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.histogram);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.histogram = SerializationUtils.toDoubleArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.histogram = SerializationUtils.toDoubleArray(in, offset, length);
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.histogram;
    }

    @Override
    public float getDistance(LireFeature vd) {
        if (!(vd instanceof Gabor)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        Gabor ch = (Gabor)vd;
        if (ch.histogram.length != this.histogram.length) {
            throw new UnsupportedOperationException("Histogram lengths or color spaces do not match");
        }
        return (float)this.getDistance(this.histogram, ch.histogram);
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(this.histogram.length * 2 + 25);
        sb.append("gabor");
        sb.append(' ');
        sb.append(this.histogram.length);
        sb.append(' ');
        for (double v : this.histogram) {
            sb.append(v);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s);
        String name = st.nextToken();
        if (!name.equals("gabor")) {
            throw new UnsupportedOperationException("This is not a Gabor feature string.");
        }
        this.histogram = new double[Integer.parseInt(st.nextToken())];
        for (int i = 0; i < this.histogram.length; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IndexOutOfBoundsException("Too few numbers in string representation.");
            }
            this.histogram[i] = Double.parseDouble(st.nextToken());
        }
    }

    @Override
    public String getFeatureName() {
        return "Gabor Features";
    }

    @Override
    public String getFieldName() {
        return "featureGabor";
    }

    static {
        int i;
        A = Math.pow(8.0, 0.25);
        theta = new double[6];
        modulationFrequency = new double[5];
        sigma_x = new double[5];
        sigma_y = new double[5];
        selfSimilarGaborWavelets = new double[4][4][5][6][2];
        LOG2 = Math.log(2.0);
        for (i = 0; i < 6; ++i) {
            Gabor.theta[i] = (double)i * Math.PI / 6.0;
        }
        for (i = 0; i < 5; ++i) {
            Gabor.modulationFrequency[i] = Math.pow(A, i) * 0.05;
            Gabor.sigma_x[i] = (A + 1.0) * Math.sqrt(2.0 * LOG2) / (Math.PI * 2 * Math.pow(A, i) * (A - 1.0) * 0.05);
            Gabor.sigma_y[i] = 1.0 / (Math.PI * 2 * Math.tan(0.2617993877991494) * Math.sqrt(Math.pow(0.4, 2.0) / (2.0 * LOG2) - Math.pow(1.0 / (Math.PI * 2 * sigma_x[i]), 2.0)));
        }
        Gabor gaborFeature = new Gabor();
        for (int s = 0; s < 4; ++s) {
            for (int t = 0; t < 4; ++t) {
                for (int m = 0; m < 5; ++m) {
                    for (int n = 0; n < 6; ++n) {
                        double[] selfSimilarGaborWavelet = gaborFeature.selfSimilarGaborWavelet(s, t, m, n);
                        Gabor.selfSimilarGaborWavelets[s][t][m][n][0] = selfSimilarGaborWavelet[0];
                        Gabor.selfSimilarGaborWavelets[s][t][m][n][1] = selfSimilarGaborWavelet[1];
                    }
                }
            }
        }
    }
}

