/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import java.util.HashMap;
import net.semanticmetadata.lire.imageanalysis.mser.BoundaryPixel;
import net.semanticmetadata.lire.imageanalysis.mser.ImagePoint;

public class BoundaryPixel8Edge
extends BoundaryPixel {
    public static final int BOTTOM_RIGHT_EDGE = 1;
    public static final int BOTTOM_LEFT_EDGE = 3;
    public static final int TOP_LEFT_EDGE = 5;
    public static final int TOP_RIGHT_EDGE = 7;
    public static final int MAX_EDGES = 8;
    private boolean clockwise;
    private int currentEdge;
    private HashMap<String, ImagePoint> imagePoints;

    public BoundaryPixel8Edge(ImagePoint point, int imageWidth, int imageHeight, boolean clockwise, HashMap<String, ImagePoint> imagePoints) {
        super(point, imageWidth, imageHeight);
        this.clockwise = clockwise;
        this.nextEdge = 4;
        this.currentEdge = 8;
        this.imagePoints = imagePoints;
    }

    public void setCurrentEdge(int edge) {
        this.currentEdge = edge;
        this.nextEdge = this.clockwise ? (this.currentEdge + 1) % 8 : (this.currentEdge > 0 ? this.currentEdge - 1 : 7);
    }

    protected ImagePoint getTopLeftNeighbor() {
        if (this.getY() == 0 || this.getX() == 0) {
            return null;
        }
        return new ImagePoint(this.getIndex() - this.imageWidth - 1, this.imageWidth);
    }

    protected ImagePoint getTopRightNeighbor() {
        if (this.getY() == 0 || this.getX() == this.imageWidth - 1) {
            return null;
        }
        return new ImagePoint(this.getIndex() - this.imageWidth + 1, this.imageWidth);
    }

    protected ImagePoint getBottomLeftNeighbor() {
        if (this.getY() == this.imageHeight - 1 || this.getX() == 0) {
            return null;
        }
        return new ImagePoint(this.getIndex() + this.imageWidth - 1, this.imageWidth);
    }

    protected ImagePoint getBottomRightNeighbor() {
        if (this.getY() == this.imageHeight - 1 || this.getX() == this.imageWidth - 1) {
            return null;
        }
        return new ImagePoint(this.getIndex() + this.imageWidth + 1, this.imageWidth);
    }

    protected ImagePoint setNextEdge(ImagePoint nextEdgePoint) {
        this.currentEdge = this.nextEdge;
        if (this.clockwise) {
            this.nextEdge = (this.nextEdge + 1) % 8;
        } else {
            int n = this.nextEdge = this.nextEdge > 0 ? this.nextEdge - 1 : 7;
        }
        if (nextEdgePoint != null && this.imagePoints.containsKey(nextEdgePoint.getX() + "_" + nextEdgePoint.getY())) {
            return nextEdgePoint;
        }
        return this.calcNextEdge();
    }

    @Override
    public ImagePoint calcNextEdge() {
        switch (this.nextEdge) {
            case 0: {
                ImagePoint nextEdgePoint = this.getRightNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
            case 1: {
                ImagePoint nextEdgePoint = this.getBottomRightNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
            case 2: {
                ImagePoint nextEdgePoint = this.getBottomNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
            case 3: {
                ImagePoint nextEdgePoint = this.getBottomLeftNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
            case 4: {
                ImagePoint nextEdgePoint = this.getLeftNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
            case 5: {
                ImagePoint nextEdgePoint = this.getTopLeftNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
            case 6: {
                ImagePoint nextEdgePoint = this.getTopNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
            case 7: {
                ImagePoint nextEdgePoint = this.getTopRightNeighbor();
                return this.setNextEdge(nextEdgePoint);
            }
        }
        this.nextEdge = 8;
        return null;
    }

    public int getNeighbourEdge() {
        switch (this.currentEdge) {
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 0: {
                return 4;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
        }
        return 8;
    }

    @Override
    public BoundaryPixel8Edge getNextBoundary() {
        ImagePoint nextEdge = this.calcNextEdge();
        if (nextEdge != null) {
            return new BoundaryPixel8Edge(nextEdge, this.imageWidth, this.imageHeight, this.clockwise, this.imagePoints);
        }
        return null;
    }
}

