/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.indexing.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.indexing.tools.Extractor;
import net.semanticmetadata.lire.utils.LuceneUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;

public class ProximityHashingIndexor {
    protected LinkedList<File> inputFiles = new LinkedList();
    protected String indexPath = null;
    private boolean overwriteIndex = true;
    protected static boolean verbose = true;
    int run = 0;
    int docCount = 0;
    HashSet<Integer> representativesID;
    ArrayList<LireFeature> representatives;
    protected Class featureClass = ColorLayout.class;

    public static void main(String[] args) throws IOException, IllegalAccessException, InstantiationException {
        ProximityHashingIndexor indexor = new ProximityHashingIndexor();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-i") || arg.startsWith("--input-file")) {
                if (i + 1 < args.length) {
                    indexor.addInputFile(new File(args[i + 1]));
                    continue;
                }
                ProximityHashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-l") || arg.startsWith("--index")) {
                if (i + 1 < args.length) {
                    indexor.setIndexPath(args[i + 1]);
                    continue;
                }
                ProximityHashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-h")) {
                ProximityHashingIndexor.printHelp();
                continue;
            }
            if (arg.startsWith("-s")) {
                verbose = false;
                continue;
            }
            if (!arg.startsWith("-c")) continue;
            if (i + 1 < args.length) {
                String file;
                BufferedReader br = new BufferedReader(new FileReader(new File(args[i + 1])));
                while ((file = br.readLine()) != null) {
                    if (file.trim().length() <= 2) continue;
                    File f = new File(file);
                    if (f.exists()) {
                        indexor.addInputFile(f);
                        continue;
                    }
                    System.err.println("Did not find file " + f.getCanonicalPath());
                }
                continue;
            }
            ProximityHashingIndexor.printHelp();
        }
        if (!indexor.isConfigured()) {
            ProximityHashingIndexor.printHelp();
        } else {
            indexor.run();
        }
    }

    protected boolean isConfigured() {
        boolean isConfigured = true;
        if (this.inputFiles.size() > 0) {
            for (File next : this.inputFiles) {
                if (next.exists()) continue;
                isConfigured = false;
                System.err.println("Input file " + next.getPath() + " does not exist.");
            }
        }
        return isConfigured;
    }

    protected static void printHelp() {
        System.out.println("Help for the Indexor class.\n===========================\nThis help text is shown if you start the Indexor with the '-h' option.\n\nUsage\n=====\n$> Indexor -i <input-file> -l <index-directory>\n\nor \n\n$> Indexor -c <file-list> -l <index-directory>\n\nwith \n\n<input-file> ... \t\ta single output file of Extractor.\n<index-directory> ...\tthe index to write the data to (it's appended).\n<file-list> ...\t\t\ta file containing data files one per line.\n");
    }

    public void setFeatureClass(Class featureClass) {
        this.featureClass = featureClass;
    }

    public void run() {
        try {
            IndexWriter indexWriter = LuceneUtils.createIndexWriter(this.indexPath, this.overwriteIndex, LuceneUtils.AnalyzerType.WhitespaceAnalyzer);
            for (File inputFile : this.inputFiles) {
                int numberOfRepresentatives;
                if (verbose) {
                    System.out.println("Processing " + inputFile.getPath() + ".");
                }
                if (verbose) {
                    System.out.println("Counting images.");
                }
                this.run = 0;
                this.readFile(indexWriter, inputFile);
                if (verbose) {
                    System.out.printf("%d images found in the data file.\n", this.docCount);
                }
                if ((numberOfRepresentatives = 1000) > this.docCount / 10) {
                    numberOfRepresentatives = this.docCount / 10;
                }
                if (verbose) {
                    System.out.printf("Selecting %d representative images for hashing.\n", numberOfRepresentatives);
                }
                this.representativesID = new HashSet(numberOfRepresentatives);
                while (this.representativesID.size() < numberOfRepresentatives) {
                    this.representativesID.add((int)Math.floor(Math.random() * (double)(this.docCount - 1)));
                }
                this.representatives = new ArrayList(numberOfRepresentatives);
                this.docCount = 0;
                this.run = 1;
                if (verbose) {
                    System.out.println("Now getting representatives from the data file.");
                }
                this.readFile(indexWriter, inputFile);
                this.docCount = 0;
                this.run = 2;
                if (verbose) {
                    System.out.println("Finally we start the indexing process, please wait ...");
                }
                this.readFile(indexWriter, inputFile);
                if (!verbose) continue;
                System.out.println("Indexing finished.");
            }
            indexWriter.commit();
            indexWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readFile(IndexWriter indexWriter, File inputFile) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(inputFile)));
        byte[] tempInt = new byte[4];
        boolean count = false;
        byte[] temp = new byte[102400];
        while (in.read(tempInt, 0, 4) > 0) {
            int tmpFeature;
            Document d = new Document();
            int tmp = SerializationUtils.toInt(tempInt);
            in.read(temp, 0, tmp);
            String filename = new String(temp, 0, tmp);
            filename = inputFile.getCanonicalPath().substring(0, inputFile.getCanonicalPath().lastIndexOf(inputFile.getName())) + filename;
            d.add((IndexableField)new StringField("descriptorImageIdentifier", filename, Field.Store.YES));
            while ((tmpFeature = in.read()) < 255) {
                LireFeature f = (LireFeature)Class.forName(Extractor.features[tmpFeature]).newInstance();
                in.read(tempInt, 0, 4);
                tmp = SerializationUtils.toInt(tempInt);
                in.read(temp, 0, tmp);
                f.setByteArrayRepresentation(temp, 0, tmp);
                this.addToDocument(f, d, Extractor.featureFieldNames[tmpFeature]);
            }
            if (this.run == 2) {
                indexWriter.addDocument((Iterable)d);
            }
            ++this.docCount;
        }
        in.close();
    }

    protected void addToDocument(LireFeature feature, Document document, String featureFieldName) {
        if (this.run != 0) {
            if (this.run == 1) {
                if (this.representativesID.contains(this.docCount) && feature.getClass().getCanonicalName().equals(this.featureClass.getCanonicalName())) {
                    this.representatives.add(feature);
                }
            } else if (this.run == 2) {
                if (feature.getClass().getCanonicalName().equals(this.featureClass.getCanonicalName())) {
                    document.add((IndexableField)new TextField(featureFieldName + "_hash", SerializationUtils.arrayToString(this.getHashes(feature)), Field.Store.YES));
                }
                document.add((IndexableField)new StoredField(featureFieldName, feature.getByteArrayRepresentation()));
            }
        }
    }

    private int[] getHashes(LireFeature feature) {
        int maximumHits = 50;
        int[] result = new int[maximumHits];
        TreeSet<SimpleResult> resultScoreDocs = new TreeSet<SimpleResult>();
        float maxDistance = 0.0f;
        float tmpScore = 0.0f;
        int rep = 0;
        for (LireFeature repFeature : this.representatives) {
            tmpScore = repFeature.getDistance(feature);
            if (resultScoreDocs.size() < maximumHits) {
                resultScoreDocs.add(new SimpleResult(tmpScore, null, rep));
                maxDistance = Math.max(maxDistance, tmpScore);
            } else if (tmpScore < maxDistance) {
                resultScoreDocs.add(new SimpleResult(tmpScore, null, rep));
            }
            while (resultScoreDocs.size() > maximumHits) {
                resultScoreDocs.remove(resultScoreDocs.last());
                maxDistance = ((SimpleResult)resultScoreDocs.last()).getDistance();
            }
            ++rep;
        }
        rep = 0;
        for (SimpleResult next : resultScoreDocs) {
            result[rep] = next.getIndexNumber();
            ++rep;
        }
        return result;
    }

    public void addInputFile(File inputFile) {
        this.inputFiles.add(inputFile);
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }
}

