/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;

public class LutApplier
implements PlugInFilter {
    ImagePlus imp;
    int min;
    int max;
    boolean canceled;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        int baseOptions = 83;
        if (imp != null && imp.getType() == 4) {
            return baseOptions + 256;
        }
        return baseOptions;
    }

    public void run(ImageProcessor ip) {
        this.apply(this.imp, ip);
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        if (ip.getMinThreshold() != -808080.0) {
            imp.unlock();
            IJ.runPlugIn("ij.plugin.Thresholder", "skip");
            return;
        }
        this.min = (int)ip.getMin();
        this.max = (int)ip.getMax();
        if (this.min == 0 && this.max == 255) {
            IJ.error("Apply LUT", "The display range must first be updated\nusing Image>Adjust>Brightness/Contrast\nor threshold levels defined using\nImage>Adjust>Threshold.");
            return;
        }
        if (imp.getType() == 4) {
            if (imp.getStackSize() > 1) {
                this.applyRGBStack(imp);
            } else {
                ip.reset();
                Undo.setup(6, imp);
                ip.setMinAndMax(this.min, this.max);
            }
            if (this.canceled) {
                ip.reset();
            }
            this.resetContrastAdjuster();
            return;
        }
        ip.resetMinAndMax();
        int[] table = new int[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = i <= this.min ? 0 : (i >= this.max ? 255 : (int)((double)(i - this.min) / (double)(this.max - this.min) * 255.0));
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            int flags = IJ.setupDialog(imp, 0);
            if (flags == 4096) {
                ip.setMinAndMax(this.min, this.max);
                return;
            }
            if (flags == 32) {
                new StackProcessor(stack, ip).applyTable(table);
                Undo.reset();
            } else {
                ip.applyTable(table);
            }
        } else {
            ip.applyTable(table);
        }
        this.resetContrastAdjuster();
    }

    void resetContrastAdjuster() {
        ContrastAdjuster.update();
    }

    void applyRGBStack(ImagePlus imp) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation.")) {
            this.canceled = true;
            return;
        }
        for (int i = 1; i <= n; ++i) {
            if (i == current) continue;
            imp.setSlice(i);
            ImageProcessor ip = imp.getProcessor();
            ip.setMinAndMax(this.min, this.max);
            IJ.showProgress((double)i / (double)n);
        }
        imp.setSlice(current);
    }
}

