/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter.awt;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.awt.environment.CwtAwtGraphicsEnvironment;
import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.pdf.pd.PDAxialShading;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.adapter.CommonGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.awt.ImageConverterPdf2Awt;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;
import de.intarsys.tools.attribute.Attribute;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.lang.ref.SoftReference;

public class AwtGraphicsEnvironmentAdapter
extends CommonGraphicsEnvironmentAdapter {
    private static AwtGraphicsEnvironmentAdapter ACTIVE;
    private static final Attribute ATTR_BUFFEREDIMAGE;

    static {
        ATTR_BUFFEREDIMAGE = new Attribute("bufferedImage");
    }

    public static AwtGraphicsEnvironmentAdapter get() {
        return ACTIVE;
    }

    public AwtGraphicsEnvironmentAdapter() {
        ACTIVE = this;
    }

    protected float adjustAlpha(float[] fArray, float f) {
        float f2 = 0.5f;
        if (fArray != null) {
            float f3 = (fArray[0] + fArray[1] + fArray[2]) / 3.0f;
            f2 = 1.0f - f3;
        }
        return f * f2;
    }

    public synchronized BufferedImage createImage(PDImage pDImage) {
        BufferedImage bufferedImage = (BufferedImage)pDImage.getAttribute((Object)ATTR_BUFFEREDIMAGE);
        if (bufferedImage == null) {
            ImageConverterPdf2Awt imageConverterPdf2Awt = new ImageConverterPdf2Awt(pDImage);
            bufferedImage = imageConverterPdf2Awt.getBufferedImage();
            pDImage.setAttribute((Object)ATTR_BUFFEREDIMAGE, (Object)bufferedImage);
        }
        return bufferedImage;
    }

    public BufferedImage createImage(PDImage pDImage, float[] fArray) {
        BufferedImage bufferedImage;
        int n = (int)(fArray[0] * 255.0f);
        int n2 = (int)(fArray[1] * 255.0f);
        int n3 = (int)(fArray[2] * 255.0f);
        String string = "awt-iimage-" + (n << 16 | n2 << 8 | n3);
        SoftReference softReference = (SoftReference)pDImage.getAttribute((Object)string);
        if (softReference != null && (bufferedImage = (BufferedImage)softReference.get()) != null) {
            return bufferedImage;
        }
        bufferedImage = this.createImage(pDImage);
        byte[] byArray = new byte[6];
        byArray[0] = (byte)n;
        byArray[1] = (byte)n2;
        byArray[2] = (byte)n3;
        byArray[3] = (byte)(n == 0 ? 1 : 0);
        byte[] byArray2 = byArray;
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray2, 0, false, 1);
        bufferedImage = new BufferedImage(indexColorModel, bufferedImage.getRaster(), false, null);
        pDImage.setAttribute((Object)string, new SoftReference<BufferedImage>(bufferedImage));
        return bufferedImage;
    }

    protected Paint createPaintColorPaint(ColorPaint colorPaint, boolean bl) {
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(colorPaint.getPdColorSpace());
        float[] fArray = colorPaint.getColorValues();
        float[] fArray2 = fArray == null ? new float[]{0.0f, 0.0f, 0.0f} : awtColorSpace.getRGB(fArray);
        float f = colorPaint.getAlphaValue();
        if (bl) {
            f = this.adjustAlpha(fArray2, f);
        }
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    protected Paint createPaintPatternPaint(PatternPaint patternPaint) {
        return new Color(0.5f, 0.5f, 0.5f, 0.5f);
    }

    protected Paint createPaintShadingPaint(ShadingPaint shadingPaint) {
        if (!(shadingPaint.getPdShading() instanceof PDAxialShading)) {
            return new Color(0.5f, 0.5f, 0.5f, 0.5f);
        }
        PDAxialShading pDAxialShading = (PDAxialShading)shadingPaint.getPdShading();
        float[] fArray = pDAxialShading.getCoords();
        float[] fArray2 = pDAxialShading.getDomain();
        PDFunction pDFunction = pDAxialShading.getFunction();
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(shadingPaint.getPdShading().getColorSpace());
        float[] fArray3 = awtColorSpace.getRGB(pDFunction.evaluate(new float[]{fArray2[0]}));
        Color color = new Color(fArray3[0], fArray3[1], fArray3[2]);
        fArray3 = awtColorSpace.getRGB(pDFunction.evaluate(new float[]{fArray2[1]}));
        Color color2 = new Color(fArray3[0], fArray3[1], fArray3[2]);
        return new GradientPaint(fArray[0], fArray[1], color, fArray[2], fArray[3], color2);
    }

    @Override
    public void drawImage(IGraphicsContext iGraphicsContext, PDImage pDImage, float f, float f2) {
        Object object;
        BufferedImage bufferedImage = this.createImage(pDImage);
        if (pDImage.isImageMask()) {
            float[] fArray = iGraphicsContext.getBackgroundColor().getRGBColorComponents(null);
            bufferedImage = this.createImage(pDImage, fArray);
        }
        float f3 = pDImage.getWidth();
        float f4 = pDImage.getHeight();
        float f5 = bufferedImage.getWidth();
        float f6 = bufferedImage.getHeight();
        AffineTransform affineTransform = null;
        if (f4 < f6 || f3 < f5) {
            affineTransform = iGraphicsContext.getTransform();
            object = new AffineTransform();
            ((AffineTransform)object).scale(f3 / f5, f4 / f6);
            iGraphicsContext.transform((AffineTransform)object);
        }
        object = (CwtAwtGraphicsContext)iGraphicsContext;
        try {
            object.getGraphics().drawImage((Image)bufferedImage, (int)f, (int)f2, null);
        }
        finally {
            if (affineTransform != null) {
                iGraphicsContext.setTransform(affineTransform);
            }
        }
    }

    @Override
    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtAwtGraphicsEnvironment.get();
    }

    @Override
    public void setBackgroundColorPaint(IGraphicsContext iGraphicsContext, ColorPaint colorPaint) {
        CwtAwtGraphicsContext cwtAwtGraphicsContext = (CwtAwtGraphicsContext)iGraphicsContext;
        Paint paint = this.createPaintColorPaint(colorPaint, cwtAwtGraphicsContext.getBlendMode() == BlendMode.MULTIPLY);
        cwtAwtGraphicsContext.setBackgroundPaint(paint);
    }

    @Override
    public void setBackgroundPatternPaint(IGraphicsContext iGraphicsContext, PatternPaint patternPaint) {
        CwtAwtGraphicsContext cwtAwtGraphicsContext = (CwtAwtGraphicsContext)iGraphicsContext;
        Paint paint = this.createPaintPatternPaint(patternPaint);
        cwtAwtGraphicsContext.setBackgroundPaint(paint);
    }

    @Override
    public void setBackgroundShadingPaint(IGraphicsContext iGraphicsContext, ShadingPaint shadingPaint) {
        CwtAwtGraphicsContext cwtAwtGraphicsContext = (CwtAwtGraphicsContext)iGraphicsContext;
        Paint paint = this.createPaintShadingPaint(shadingPaint);
        cwtAwtGraphicsContext.setBackgroundPaint(paint);
    }

    @Override
    public void setForegroundColorPaint(IGraphicsContext iGraphicsContext, ColorPaint colorPaint) {
        CwtAwtGraphicsContext cwtAwtGraphicsContext = (CwtAwtGraphicsContext)iGraphicsContext;
        Paint paint = this.createPaintColorPaint(colorPaint, cwtAwtGraphicsContext.getBlendMode() == BlendMode.MULTIPLY);
        cwtAwtGraphicsContext.setForegroundPaint(paint);
    }

    @Override
    public void setForegroundPatternPaint(IGraphicsContext iGraphicsContext, PatternPaint patternPaint) {
        CwtAwtGraphicsContext cwtAwtGraphicsContext = (CwtAwtGraphicsContext)iGraphicsContext;
        Paint paint = this.createPaintPatternPaint(patternPaint);
        cwtAwtGraphicsContext.setForegroundPaint(paint);
    }

    @Override
    public void setForegroundShadingPaint(IGraphicsContext iGraphicsContext, ShadingPaint shadingPaint) {
        CwtAwtGraphicsContext cwtAwtGraphicsContext = (CwtAwtGraphicsContext)iGraphicsContext;
        Paint paint = this.createPaintShadingPaint(shadingPaint);
        cwtAwtGraphicsContext.setForegroundPaint(paint);
    }
}

