/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.License;
import adams.core.Time;
import adams.core.annotation.MixedCopyright;
import adams.core.management.LocaleHelper;
import adams.data.DateFormatString;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

@MixedCopyright(copyright="Apache Foundation, POI 3.11", license=License.APACHE2, note="Excel date handling taken from: org.apache.poi.ss.usermodel.DateUtil")
public class DateUtils {
    protected static TimeZone m_TimeZone = TimeZone.getDefault();
    protected static Locale m_Locale = LocaleHelper.getSingleton().getDefault();
    public static final int BAD_DATE = -1;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int SECONDS_PER_DAY = 86400;
    public static final long DAY_MILLISECONDS = 86400000L;

    public static synchronized void setTimeZone(TimeZone value) {
        m_TimeZone = value;
    }

    public static synchronized TimeZone getTimeZone() {
        return m_TimeZone;
    }

    public static synchronized void setLocale(Locale value) {
        m_Locale = value;
    }

    public static synchronized Locale getLocale() {
        return m_Locale;
    }

    public static synchronized Calendar getCalendar() {
        return new GregorianCalendar(DateUtils.getTimeZone(), DateUtils.getLocale());
    }

    public static DateFormat getTimestampFormatter() {
        return new DateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static DateFormat getTimestampFormatterMsecs() {
        return new DateFormat("yyyy-MM-dd HH:mm:ss.S");
    }

    public static DateFormat getTimeFormatter() {
        return new DateFormat("HH:mm:ss");
    }

    public static DateFormat getTimeFormatterMsecs() {
        return new DateFormat("HH:mm:ss.S");
    }

    public static DateFormat getDateFormatter() {
        return new DateFormat("yyyy-MM-dd");
    }

    public static boolean isValid(String pattern) {
        try {
            new SimpleDateFormat(pattern);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date earlier(Date date, int type, int decrement) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(type, -Math.abs(decrement));
        return cal.getTime();
    }

    public static Date later(Date date, int type, int increment) {
        Calendar cal = DateUtils.getCalendar();
        cal.setTime(date);
        cal.add(type, Math.abs(increment));
        return cal.getTime();
    }

    public static Date set(Date date, int type, int value) {
        Date result;
        Calendar cal = DateUtils.getCalendar();
        cal.setLenient(false);
        cal.setTime(date);
        try {
            cal.set(type, value);
            result = cal.getTime();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static boolean isBefore(Date base, Date check) {
        return base.compareTo(check) > 0;
    }

    public static boolean isAfter(Date base, Date check) {
        return base.compareTo(check) < 0;
    }

    public static Long difference(Date older, Date newer) {
        if (older.compareTo(newer) < 0) {
            return newer.getTime() - older.getTime();
        }
        return null;
    }

    public static Double differenceDays(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0 / 60.0 / 60.0 / 24.0;
    }

    public static Double differenceHours(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0 / 60.0 / 60.0;
    }

    public static Double differenceMinutes(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0 / 60.0;
    }

    public static Double differenceSeconds(Date older, Date newer) {
        Long msecs = DateUtils.difference(older, newer);
        if (msecs == null) {
            return null;
        }
        return (double)msecs.longValue() / 1000.0;
    }

    public static String msecToString(Long msec) {
        StringBuilder result = new StringBuilder();
        if (msec == null) {
            result.append("invalid");
        } else {
            long value = msec;
            long position = value / 3600000L;
            if (position < 10L) {
                result.append("0");
            }
            result.append(position);
            position = (value %= 3600000L) / 60000L;
            result.append(":");
            if (position < 10L) {
                result.append("0");
            }
            result.append(position);
            position = (value %= 60000L) / 1000L;
            result.append(":");
            if (position < 10L) {
                result.append("0");
            }
            result.append(position);
            position = value % 1000L;
            result.append(".");
            if (position < 10L) {
                result.append("0");
            }
            if (position < 100L) {
                result.append("0");
            }
            result.append(position);
        }
        return result.toString();
    }

    public static Date parseString(String s, String format) {
        return DateUtils.parseString(s, new DateFormatString(format));
    }

    public static Date parseString(String s, DateFormatString format) {
        return format.toDateFormat().parse(s);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public static Time nowTime() {
        GregorianCalendar cal = new GregorianCalendar(DateUtils.getLocale());
        cal.setTime(new Date());
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 1);
        return new Time(cal.getTime());
    }

    public static Date today() {
        GregorianCalendar cal = new GregorianCalendar(DateUtils.getLocale());
        cal.setTime(new Date());
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    protected static Calendar dayStart(Calendar cal) {
        cal.get(11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.get(11);
        return cal;
    }

    protected static int absoluteDay(Calendar cal, boolean use1904windowing) {
        return cal.get(6) + DateUtils.daysInPriorYears(cal.get(1), use1904windowing);
    }

    protected static int daysInPriorYears(int yr, boolean use1904windowing) {
        if (!use1904windowing && yr < 1900 || use1904windowing && yr < 1900) {
            throw new IllegalArgumentException("'year' must be 1900 or greater");
        }
        int yr1 = yr - 1;
        int leapDays = yr1 / 4 - yr1 / 100 + yr1 / 400 - 460;
        return 365 * (yr - (use1904windowing ? 1904 : 1900)) + leapDays;
    }

    protected static double internalGetExcelDate(Calendar date, boolean use1904windowing) {
        if (!use1904windowing && date.get(1) < 1900 || use1904windowing && date.get(1) < 1904) {
            return -1.0;
        }
        double fraction = (double)(((date.get(11) * 60 + date.get(12)) * 60 + date.get(13)) * 1000 + date.get(14)) / 8.64E7;
        Calendar calStart = DateUtils.dayStart(date);
        double value = fraction + (double)DateUtils.absoluteDay(calStart, use1904windowing);
        if (!use1904windowing && value >= 60.0) {
            value += 1.0;
        } else if (use1904windowing) {
            value -= 1.0;
        }
        return value;
    }

    public static double msecToSerialDate(long msec) {
        return DateUtils.msecToSerialDate(new Date(msec));
    }

    public static double msecToSerialDate(Date date) {
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTime(date);
        return DateUtils.internalGetExcelDate(calStart, false);
    }

    protected static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    protected static void setCalendar(Calendar calendar, int wholeDays, int millisecondsInDay, boolean use1904windowing, boolean roundSeconds) {
        int startYear = 1900;
        int dayAdjust = -1;
        if (use1904windowing) {
            startYear = 1904;
            dayAdjust = 1;
        } else if (wholeDays < 61) {
            dayAdjust = 0;
        }
        calendar.set(startYear, 0, wholeDays + dayAdjust, 0, 0, 0);
        calendar.set(14, millisecondsInDay);
        if (roundSeconds) {
            calendar.add(14, 500);
            calendar.clear(14);
        }
    }

    protected static Calendar getJavaCalendar(double date, boolean use1904windowing, TimeZone timeZone, boolean roundSeconds) {
        if (!DateUtils.isValidExcelDate(date)) {
            return null;
        }
        int wholeDays = (int)Math.floor(date);
        int millisecondsInDay = (int)((date - (double)wholeDays) * 8.64E7 + 0.5);
        GregorianCalendar calendar = timeZone != null ? new GregorianCalendar(timeZone) : new GregorianCalendar();
        DateUtils.setCalendar(calendar, wholeDays, millisecondsInDay, use1904windowing, roundSeconds);
        return calendar;
    }

    public static Date serialDateToDate(double serial) {
        return new Date(DateUtils.serialDateToMsec(serial));
    }

    public static long serialDateToMsec(double serial) {
        return DateUtils.getJavaCalendar(serial, false, null, false).getTimeInMillis();
    }

    public static boolean checkTime(String s) {
        return DateUtils.checkTime(s, null);
    }

    public static boolean checkTime(String s, DateFormat df) {
        if (df == null) {
            df = DateUtils.getTimeFormatter();
        }
        if (s.indexOf(58) > -1) {
            return df.check(s);
        }
        return false;
    }

    public static boolean checkDate(String s) {
        return DateUtils.checkDate(s, null);
    }

    public static boolean checkDate(String s, DateFormat df) {
        if (df == null) {
            df = DateUtils.getDateFormatter();
        }
        if (s.indexOf(45) > -1) {
            return df.check(s);
        }
        return false;
    }

    public static boolean checkDateTime(String s) {
        return DateUtils.checkDate(s, null);
    }

    public static boolean checkDateTime(String s, DateFormat df) {
        if (df == null) {
            df = DateUtils.getTimestampFormatter();
        }
        if (s.indexOf(45) > -1 && s.indexOf(58) > -1) {
            return df.check(s);
        }
        return false;
    }
}

