/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.ClassLocator;
import adams.core.EnumWithCustomDisplay;
import adams.core.option.EnumOption;
import java.lang.reflect.Method;

public class EnumHelper {
    public static final String METHOD_VALUES = "values";

    public static Object[] getValues(Object obj) {
        return EnumHelper.getValues(obj.getClass());
    }

    public static Object[] getValues(Class cls) {
        Object[] result;
        try {
            Method method = cls.getMethod(METHOD_VALUES, new Class[0]);
            result = (Object[])method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            System.err.println("Failed to obtain all enum values for enum: " + cls);
            e.printStackTrace();
            result = new Object[]{};
        }
        return result;
    }

    public static Class determineClass(Object obj) {
        Class<?> result = obj.getClass();
        if (result.isArray()) {
            result = result.getComponentType();
        }
        return result;
    }

    public static Object parse(Class cls, String s) {
        Object result = null;
        if (ClassLocator.hasInterface(EnumWithCustomDisplay.class, cls)) {
            EnumWithCustomDisplay enm = EnumOption.getEnumInstance(cls);
            result = enm.parse(s);
        } else {
            result = Enum.valueOf(cls, s);
        }
        return result;
    }
}

