/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.option.AbstractOption;
import java.net.URL;

public enum License {
    UNKNOWN,
    PROPRIETARY,
    TODO,
    PUBLIC_DOMAIN("Public domain"),
    APACHE2("Apache", "2.0", "http://opensource.org/licenses/Apache-2.0"),
    BSD2("BSD", "2-clause", "http://opensource.org/licenses/BSD-2-Clause"),
    BSD3("BSD", "3-clause", "http://opensource.org/licenses/BSD-3-Clause"),
    CC_PD("CC Public Domain", null, "http://creativecommons.org/licenses/publicdomain/"),
    CC_BY_SA_25("CC BY-SA", "2.5", "http://creativecommons.org/licenses/by-sa/2.5/"),
    CC_BY_SA_3("CC BY-SA", "3.0", "http://creativecommons.org/licenses/by-sa/3.0/"),
    CC_BY_NC_SA_25("CC BY-NC-SA", "2.5", "http://creativecommons.org/licenses/by-nc-sa/2.5/"),
    GPL2("GPL", "2", "http://opensource.org/licenses/GPL-2.0"),
    GPL3("GPL", "3", "http://opensource.org/licenses/GPL-3.0"),
    LGPL21("LGPL", "2.1", "http://opensource.org/licenses/LGPL-2.1"),
    LGPL3("LGPL", "3.0", "http://opensource.org/licenses/LGPL-3.0"),
    MIT("MIT", null, "http://opensource.org/licenses/MIT");

    private String m_License;
    private String m_Version;
    private String m_Raw = super.toString();
    private URL m_URL;

    private License() {
        this(null, null, null);
    }

    private License(String license) {
        this(license, null, null);
    }

    private License(String license, String version) {
        this(license, version, null);
    }

    private License(String license, String version, String url) {
        this.m_License = license;
        this.m_Version = version;
        this.m_URL = null;
        if (url != null) {
            try {
                this.m_URL = new URL(url);
            }
            catch (Exception e) {
                this.m_URL = null;
                System.err.println("Failed to parse URL: " + url);
                e.printStackTrace();
            }
        }
    }

    public String toDisplay() {
        StringBuilder result = new StringBuilder();
        if (this.m_URL != null) {
            result.insert(0, " (" + this.m_URL + ")");
        }
        if (this.m_Version != null) {
            if (result.length() > 0) {
                result.insert(0, " ");
            }
            result.insert(0, this.m_Version);
        }
        if (this.m_License != null) {
            if (result.length() > 0) {
                result.insert(0, " ");
            }
            result.insert(0, this.m_License);
        }
        if (result.length() == 0) {
            result.append(this.m_Raw);
        }
        return result.toString();
    }

    public String toRaw() {
        return this.m_Raw;
    }

    public String toString() {
        return this.toDisplay();
    }

    public License parse(String s) {
        return License.valueOf((AbstractOption)null, s);
    }

    public static String toString(AbstractOption option, Object object) {
        return ((License)((Object)object)).toRaw();
    }

    public static License valueOf(AbstractOption option, String str) {
        License result = null;
        try {
            result = License.valueOf(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            for (License dt : License.values()) {
                if (!dt.toDisplay().equals(str)) continue;
                result = dt;
                break;
            }
        }
        return result;
    }
}

