/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseObject;
import adams.gui.core.ColorHelper;
import java.awt.Color;

public class BaseColor
extends BaseObject {
    private static final long serialVersionUID = -5853830144343397434L;
    public static final String DEFAULT = "#000000";

    public BaseColor() {
        this(DEFAULT);
    }

    public BaseColor(String s) {
        super(s);
    }

    public BaseColor(Color color) {
        super(ColorHelper.toHex(color));
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    @Override
    public boolean isValid(String value) {
        return ColorHelper.valueOf(value, null) != null;
    }

    @Override
    public void setValue(String value) {
        if (this.isValid(value)) {
            this.m_Internal = ColorHelper.toHex(ColorHelper.valueOf(value));
        }
    }

    @Override
    public String getValue() {
        return (String)((Object)this.m_Internal);
    }

    public Color toColorValue() {
        return ColorHelper.valueOf((String)((Object)this.m_Internal));
    }

    @Override
    public String getTipText() {
        return "A color definition.";
    }
}

