/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.Utils;
import adams.core.base.AbstractBaseString;
import java.awt.geom.Point2D;

public class BasePointDouble
extends AbstractBaseString {
    private static final long serialVersionUID = -3504062141216626521L;
    public static final String SEPARATOR = ";";
    public static final String DEFAULT = "0;0";

    public BasePointDouble() {
        this(DEFAULT);
    }

    public BasePointDouble(String s) {
        super(s);
    }

    public BasePointDouble(Point2D.Double value) {
        this(BasePointDouble.toString(value));
    }

    public BasePointDouble(Double x, Double y) {
        this(new Point2D.Double(x, y));
    }

    @Override
    protected void initialize() {
        this.m_Internal = DEFAULT;
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        return this.parse(value) != null;
    }

    public Point2D.Double pointValue() {
        return this.parse((String)((Object)this.m_Internal));
    }

    @Override
    public String getTipText() {
        return "An float point (x;y).";
    }

    public static String toString(Point2D.Double d) {
        return d.x + SEPARATOR + d.y;
    }

    public Point2D.Double parse(String s) {
        String[] parts;
        Point2D.Double result = null;
        if (s.indexOf(SEPARATOR) > 0 && (parts = s.split(SEPARATOR)).length == 2 && Utils.isDouble(parts[0]) && Utils.isDouble(parts[1])) {
            result = new Point2D.Double(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]));
        }
        return result;
    }
}

