/*
 * Decompiled with CFR 0.152.
 */
package adams.core.logging;

import adams.core.logging.LoggingListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public abstract class AbstractLogHandler
extends Handler {
    protected HashSet<LoggingListener> m_LoggingListeners;

    protected AbstractLogHandler() {
        this.initialize();
    }

    protected void initialize() {
        this.m_LoggingListeners = new HashSet();
    }

    protected abstract void doPublish(LogRecord var1);

    @Override
    public void publish(LogRecord record) {
        this.doPublish(record);
        this.notifyLoggingListeners(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public void addLoggingListener(LoggingListener l) {
        this.m_LoggingListeners.add(l);
    }

    public void removeLoggingListener(LoggingListener l) {
        this.m_LoggingListeners.remove(l);
    }

    public void removeLoggingListeners() {
        this.m_LoggingListeners.clear();
    }

    public Iterator<LoggingListener> iterator() {
        return this.m_LoggingListeners.iterator();
    }

    public Set<LoggingListener> loggingListeners() {
        return new HashSet<LoggingListener>(this.m_LoggingListeners);
    }

    protected void notifyLoggingListeners(LogRecord record) {
        LoggingListener[] listeners;
        for (LoggingListener l : listeners = this.m_LoggingListeners.toArray(new LoggingListener[0])) {
            l.logEventOccurred(this, record);
        }
    }
}

