/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.Properties;
import adams.env.Environment;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;

public class CharsetHelper {
    public static final String FILENAME = "Charset.props";
    public static final String CHARSET = "Charset";
    public static final String CHARSET_DEFAULT = "Default";
    protected static CharsetHelper m_Singleton;
    protected Properties m_Properties;
    protected boolean m_Modified;

    private CharsetHelper() {
        this.initialize();
        this.reload();
    }

    protected void initialize() {
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public Charset getCharset() {
        return Charset.forName(this.m_Properties.getProperty(CHARSET, Charset.defaultCharset().name()));
    }

    public void setCharset(Charset value) {
        this.setCharset(value.name());
    }

    public void setCharset(String value) {
        this.m_Modified = true;
        this.m_Properties.setProperty(CHARSET, value);
    }

    public synchronized void reload() {
        this.m_Modified = false;
        try {
            this.m_Properties = Environment.getInstance().read("locale");
        }
        catch (Exception e) {
            this.m_Properties = new Properties();
        }
    }

    public synchronized boolean save() {
        boolean result = Environment.getInstance().write("locale", this.m_Properties);
        if (result) {
            this.m_Modified = false;
        }
        return result;
    }

    public static synchronized CharsetHelper getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new CharsetHelper();
        }
        return m_Singleton;
    }

    public static String toString(Charset l) {
        String result = l.name();
        if (result.equals(Charset.defaultCharset().name())) {
            result = CHARSET_DEFAULT;
        }
        return result;
    }

    public static Charset valueOf(String str) {
        if (str.equals(CHARSET_DEFAULT)) {
            return Charset.defaultCharset();
        }
        try {
            return Charset.forName(str);
        }
        catch (Exception e) {
            System.err.println("Failed to parse charset: " + str);
            return Charset.defaultCharset();
        }
    }

    public static String[] getIDs() {
        Charset[] charsets;
        ArrayList<String> result = new ArrayList<String>();
        for (Charset l : charsets = Charset.availableCharsets().values().toArray(new Charset[0])) {
            result.add(l.toString());
        }
        Collections.sort(result);
        result.add(0, CHARSET_DEFAULT);
        return result.toArray(new String[result.size()]);
    }
}

