/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.Utils;
import adams.core.io.PlaceholderDirectory;
import adams.core.management.OS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.HashMap;

public class ProcessUtils {
    public static final long AUTO_PID = -999L;
    public static final long NO_PID = -1L;

    public static long getVirtualMachinePID() {
        long result;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            result = Long.parseLong(name.replaceAll("@.*", ""));
        }
        catch (Exception e) {
            result = -1L;
        }
        return result;
    }

    public static ProcessResult execute(String cmd) throws Exception {
        return ProcessUtils.execute(cmd, null);
    }

    public static ProcessResult execute(String cmd, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, (String[])null, cwd);
    }

    public static ProcessResult execute(String cmd, HashMap<String, String> env, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, ProcessUtils.convertHashMap(env), cwd);
    }

    public static ProcessResult execute(String cmd, HashMap<String, String> env, String input, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, ProcessUtils.convertHashMap(env), input, cwd);
    }

    public static ProcessResult execute(String cmd, String[] env, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, env, null, cwd);
    }

    public static ProcessResult execute(String[] cmd) throws Exception {
        return ProcessUtils.execute(cmd, null);
    }

    public static ProcessResult execute(String[] cmd, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, (String[])null, cwd);
    }

    public static ProcessResult execute(String[] cmd, HashMap<String, String> env, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, ProcessUtils.convertHashMap(env), cwd);
    }

    public static ProcessResult execute(String[] cmd, HashMap<String, String> env, String input, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, ProcessUtils.convertHashMap(env), input, cwd);
    }

    public static ProcessResult execute(String[] cmd, String[] env, PlaceholderDirectory cwd) throws Exception {
        return ProcessUtils.execute(cmd, env, null, cwd);
    }

    public static ProcessResult execute(String[] cmd, String[] env, String input, PlaceholderDirectory cwd) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd, env, cwd == null ? null : cwd.getAbsoluteFile());
        return new ProcessResult(cmd, env, input, process);
    }

    public static ProcessResult execute(String cmd, String[] env, String input, PlaceholderDirectory cwd) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd, env, cwd == null ? null : cwd.getAbsoluteFile());
        return new ProcessResult(cmd, env, input, process);
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static HashMap<String, String> getEnvironment() {
        HashMap<String, String> result = new HashMap<String, String>(System.getenv());
        return result;
    }

    protected static String[] convertHashMap(HashMap<String, String> env) {
        String[] result = null;
        if (env != null) {
            result = new String[env.size()];
            int i = 0;
            for (String key : env.keySet()) {
                result[i] = key + "=" + env.get(key);
                ++i;
            }
        }
        return result;
    }

    public static String escapeBlanks(String path) {
        if (OS.isWindows()) {
            return path.replace(" ", "^ ");
        }
        return path;
    }

    public static final class ProcessResult
    implements Serializable {
        private static final long serialVersionUID = 1902809285333524039L;
        protected String[] m_Command;
        protected String[] m_Environment;
        protected int m_ExitCode;
        protected String m_StdOut;
        protected String m_StdErr;

        public ProcessResult(String cmd, String[] env, String input, Process process) throws Exception {
            this(new String[]{cmd}, env, input, process);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcessResult(String[] cmd, String[] env, String input, final Process process) throws Exception {
            final StringBuilder stde = new StringBuilder();
            Runnable rune = new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()), 1024);
                        while ((line = reader.readLine()) != null) {
                            stde.append(line);
                            stde.append("\n");
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to reader stderr for process #" + process.hashCode() + ":");
                        e.printStackTrace();
                    }
                }
            };
            Thread threade = new Thread(rune);
            threade.start();
            final StringBuilder stdo = new StringBuilder();
            Runnable runo = new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
                        while ((line = reader.readLine()) != null) {
                            stdo.append(line);
                            stdo.append("\n");
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to reader stdout for process #" + process.hashCode() + ":");
                        e.printStackTrace();
                    }
                }
            };
            Thread threado = new Thread(runo);
            threado.start();
            if (input != null) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                writer.write(input);
                writer.close();
            }
            this.m_Command = cmd;
            this.m_Environment = env;
            this.m_ExitCode = process.waitFor();
            while (threade.isAlive() || threado.isAlive()) {
                try {
                    ProcessResult processResult = this;
                    synchronized (processResult) {
                        this.wait(100L);
                    }
                }
                catch (Exception exception) {
                }
            }
            this.m_StdOut = stdo.toString();
            this.m_StdErr = stde.toString();
        }

        public boolean hasSucceeded() {
            return this.m_ExitCode == 0;
        }

        public int getExitCode() {
            return this.m_ExitCode;
        }

        public String[] getCommand() {
            return this.m_Command;
        }

        public String[] getEnvironment() {
            return this.m_Environment;
        }

        public String getStdOut() {
            return this.m_StdOut;
        }

        public String getStdErr() {
            return this.m_StdErr;
        }

        public String toString() {
            return "exit code=" + this.m_ExitCode;
        }

        public String toErrorOutput() {
            StringBuilder result = new StringBuilder();
            if (this.m_ExitCode == 0) {
                result.append("Command succeeded!");
            } else {
                result.append("Command failed with exit code " + this.m_ExitCode + "!\n");
                result.append("--> Command:\n");
                result.append(Utils.flatten(this.m_Command, "\n"));
                result.append("\n\n");
                if (this.m_Environment != null) {
                    result.append("--> Environemtn:\n");
                    result.append(Utils.flatten(this.m_Environment, "\n"));
                    result.append("\n\n");
                }
                result.append("--> Error output:\n");
                result.append(this.m_StdErr);
            }
            return result.toString();
        }
    }
}

