/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.Properties;
import adams.core.management.OS;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import java.io.File;

public class Terminal {
    public static final String FILENAME = "adams/core/management/Terminal.props";
    public static final String LINUX_EXECUTABLE = "LinuxExecutable";
    public static final String LINUX_OPTIONS = "LinuxOptions";
    public static final String MAC_EXECUTABLE = "MacExecutable";
    public static final String MAC_OPTIONS = "MacOptions";
    public static final String WINDOWS_EXECUTABLE = "WindowsExecutable";
    public static final String WINDOWS_OPTIONS = "WindowsOptions";
    public static final String PLACEHOLDR_DIR = "%d";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            Properties result;
            try {
                result = Properties.read(FILENAME);
            }
            catch (Exception e) {
                result = new Properties();
            }
            m_Properties = result;
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return Terminal.writeProperties(Terminal.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        String filename = Environment.getInstance().createPropertiesFilename(new File(FILENAME).getName());
        boolean result = props.save(filename);
        m_Properties = null;
        return result;
    }

    public static String getWindowsExecutable() {
        return Terminal.getProperties().getProperty(WINDOWS_EXECUTABLE);
    }

    public static String getLinuxExecutable() {
        return Terminal.getProperties().getProperty(LINUX_EXECUTABLE);
    }

    public static String getMacExecutable() {
        return Terminal.getProperties().getProperty(MAC_EXECUTABLE);
    }

    public static String getExecutable() {
        if (OS.isWindows()) {
            return Terminal.getWindowsExecutable();
        }
        if (OS.isMac()) {
            return Terminal.getMacExecutable();
        }
        return Terminal.getLinuxExecutable();
    }

    public static String getWindowsOptions() {
        return Terminal.getProperties().getProperty(WINDOWS_OPTIONS);
    }

    public static String getLinuxOptions() {
        return Terminal.getProperties().getProperty(LINUX_OPTIONS);
    }

    public static String getMacOptions() {
        return Terminal.getProperties().getProperty(MAC_OPTIONS);
    }

    public static String getOptions() {
        if (OS.isWindows()) {
            return Terminal.getWindowsOptions();
        }
        if (OS.isMac()) {
            return Terminal.getMacOptions();
        }
        return Terminal.getLinuxOptions();
    }

    public static String getCommand(File dir) {
        if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        return Terminal.getExecutable() + " " + Terminal.getOptions().replace(PLACEHOLDR_DIR, dir.getAbsolutePath());
    }

    public static boolean launch(File dir) {
        String cmd = Terminal.getCommand(dir);
        try {
            String[] parts = OptionUtils.splitOptions(cmd);
            ProcessBuilder pb = new ProcessBuilder(parts);
            pb.start();
            return true;
        }
        catch (Exception e) {
            System.err.println("Failed to launch terminal: " + cmd);
            e.printStackTrace();
            return false;
        }
    }
}

