/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.base.BaseString;
import adams.core.option.AbstractFlowJavaCodeProducer;
import adams.env.Environment;
import adams.flow.sink.Display;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FlowJUnitTestProducer
extends AbstractFlowJavaCodeProducer {
    private static final long serialVersionUID = -422414504795720518L;
    protected Class m_ActorClass;
    protected boolean m_HasRegressionTest;
    protected BaseString[] m_RegressionFiles;

    @Override
    public String globalInfo() {
        return "Generates a JUnit test case for flows.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor-class", "actorClass", this.getDefaultActorClass());
        this.m_OptionManager.add("has-regression-test", "hasRegressionTest", false);
        this.m_OptionManager.add("regression-file", "regressionFiles", new BaseString[]{new BaseString("dumpfile.txt")});
    }

    protected String getDefaultActorClass() {
        return Display.class.getName();
    }

    public void setActorClass(String value) {
        try {
            this.m_ActorClass = Class.forName(value);
            this.setSimpleName(this.m_ActorClass.getSimpleName());
            this.setPackage(this.m_ActorClass.getPackage().getName());
            this.reset();
        }
        catch (Exception e) {
            this.m_ActorClass = Display.class;
            this.getLogger().severe("Error instantiating class: " + e);
        }
    }

    public String getActorClass() {
        return this.m_ActorClass.getName();
    }

    public String actorClassTipText() {
        return "The name of the actor class that this test is generated for.";
    }

    public void setHasRegressionTest(boolean value) {
        this.m_HasRegressionTest = value;
        this.reset();
    }

    public boolean getHasRegressionTest() {
        return this.m_HasRegressionTest;
    }

    public String hasRegressionTestTipText() {
        return "Whether a method for a regression test should be added.";
    }

    public void setRegressionFiles(BaseString[] value) {
        this.m_RegressionFiles = value;
        this.reset();
    }

    public BaseString[] getRegressionFiles() {
        return this.m_RegressionFiles;
    }

    public String regressionFilesTipText() {
        return "The files to use in the regression test (if one is generated).";
    }

    @Override
    protected List<String> getRequiredImports() {
        ArrayList<String> result = new ArrayList<String>(super.getRequiredImports());
        result.add("junit.framework.Test");
        result.add("junit.framework.TestSuite");
        result.add("adams.flow.core.AbstractActor");
        result.add("adams.flow.control.Flow");
        result.add("adams.flow.AbstractFlowTest");
        if (this.m_HasRegressionTest) {
            result.add("adams.test.TmpFile");
        }
        return result;
    }

    @Override
    protected String getIndentation() {
        return "      ";
    }

    @Override
    protected void addCopyright() {
        this.m_OutputBuffer.append("/*\n");
        this.m_OutputBuffer.append(" * " + this.m_SimpleName + "Test.java" + "\n");
        if (this.m_Copyright.length() > 0) {
            SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
            this.m_OutputBuffer.append(" * Copyright (C) " + yearFormatter.format(new Date()) + " " + this.m_Copyright + "\n");
        }
        this.m_OutputBuffer.append(" */\n");
        this.m_OutputBuffer.append("\n");
    }

    @Override
    protected void addClassJavadoc() {
        this.m_OutputBuffer.append("/**\n");
        this.m_OutputBuffer.append(" * Test for " + this.m_SimpleName + " actor." + "\n");
        this.m_OutputBuffer.append(" *\n");
        this.m_OutputBuffer.append(" * @author " + System.getProperty("user.name") + "\n");
        this.m_OutputBuffer.append(" * @author " + this.getClass().getName() + " (code generator)" + "\n");
        this.m_OutputBuffer.append(" * @version $Revision$\n");
        this.m_OutputBuffer.append(" */\n");
    }

    @Override
    protected void addClassStart() {
        this.m_OutputBuffer.append("public class " + this.m_SimpleName + "Test" + "\n");
        this.m_OutputBuffer.append("  extends AbstractFlowTest {\n");
        this.m_OutputBuffer.append("\n");
    }

    @Override
    protected void addConstructor() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Initializes the test.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param name\tthe name of the test\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public " + this.m_SimpleName + "Test(String name) {\n");
        this.m_OutputBuffer.append("    super(name);\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }

    @Override
    protected void addAdditionalMethods() {
        int i;
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Called by JUnit before each test method.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @throws Exception \tif an error occurs.\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  protected void setUp() throws Exception {\n");
        this.m_OutputBuffer.append("    super.setUp();\n");
        this.m_OutputBuffer.append("    \n");
        this.m_OutputBuffer.append("    //m_TestHelper.copyResourceToTmp(\"some.csv\");\n");
        if (this.m_HasRegressionTest) {
            for (i = 0; i < this.m_RegressionFiles.length; ++i) {
                this.m_OutputBuffer.append("    m_TestHelper.deleteFileFromTmp(\"" + this.m_RegressionFiles[i].getValue() + "\");\n");
            }
        }
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Called by JUnit after each test method.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @throws Exception\tif tear-down fails\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  protected void tearDown() throws Exception {\n");
        this.m_OutputBuffer.append("    //m_TestHelper.deleteFileFromTmp(\"some.csv\");\n");
        if (this.m_HasRegressionTest) {
            for (i = 0; i < this.m_RegressionFiles.length; ++i) {
                this.m_OutputBuffer.append("    m_TestHelper.deleteFileFromTmp(\"" + this.m_RegressionFiles[i].getValue() + "\");\n");
            }
        }
        this.m_OutputBuffer.append("    \n");
        this.m_OutputBuffer.append("    super.tearDown();\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
        if (this.m_HasRegressionTest) {
            this.m_OutputBuffer.append("  /**\n");
            this.m_OutputBuffer.append("   * Performs a regression test, comparing against previously generated output.\n");
            this.m_OutputBuffer.append("   */\n");
            this.m_OutputBuffer.append("  public void testRegression() {\n");
            this.m_OutputBuffer.append("    performRegressionTest(\n");
            this.m_OutputBuffer.append("        new TmpFile[]{\n");
            for (i = 0; i < this.m_RegressionFiles.length; ++i) {
                this.m_OutputBuffer.append("          new TmpFile(\"" + this.m_RegressionFiles[i].getValue() + "\")");
                if (i < this.m_RegressionFiles.length - 1) {
                    this.m_OutputBuffer.append(",");
                }
                this.m_OutputBuffer.append("\n");
            }
            this.m_OutputBuffer.append("        });\n");
            this.m_OutputBuffer.append("  }\n");
            this.m_OutputBuffer.append("\n");
        }
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * \n");
        this.m_OutputBuffer.append("   * Returns a test suite.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @return\t\tthe test suite\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public static Test suite() {\n");
        this.m_OutputBuffer.append("    return new TestSuite(" + this.m_SimpleName + "Test" + ".class);\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }

    @Override
    protected void addMethodStart() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Used to create an instance of a specific actor.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @return a suitably configured <code>AbstractActor</code> value\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public AbstractActor getActor() {\n");
        this.m_OutputBuffer.append("    AbstractArgumentOption    argOption;\n");
        this.m_OutputBuffer.append("    \n");
        this.m_OutputBuffer.append("    Flow " + this.getOuterVariableName() + " = new Flow();\n");
        this.m_OutputBuffer.append("    \n");
        this.m_OutputBuffer.append("    try {\n");
    }

    @Override
    protected void addMethodEnd() {
        this.m_OutputBuffer.append("    }\n");
        this.m_OutputBuffer.append("    catch (Exception e) {\n");
        this.m_OutputBuffer.append("      fail(\"Failed to set up actor: \" + e);\n");
        this.m_OutputBuffer.append("    }\n");
        this.m_OutputBuffer.append("    \n");
        this.m_OutputBuffer.append("    return " + this.getOuterVariableName() + ";\n");
        this.m_OutputBuffer.append("  }\n");
    }

    @Override
    protected void addMainMethod() {
        this.m_OutputBuffer.append("\n");
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Runs the test from commandline.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param args\tignored\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public static void main(String[] args) {\n");
        this.m_OutputBuffer.append("    Environment.setEnvironmentClass(" + Environment.getEnvironmentClass().getName() + ".class);\n");
        this.m_OutputBuffer.append("    runTest(suite());\n");
        this.m_OutputBuffer.append("  }\n");
    }

    @Override
    protected void preProduce() {
        this.m_SimpleName = this.m_ActorClass.getSimpleName();
        this.m_Package = this.m_ActorClass.getPackage().getName();
        super.preProduce();
    }

    public static void main(String[] args) {
        FlowJUnitTestProducer.runProducer(FlowJUnitTestProducer.class, args);
    }
}

