/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NestedFormatHelper {
    public static int removeComments(List<String> lines) {
        int result = 0;
        while (lines.size() > 0 && lines.get(0).startsWith("#")) {
            ++result;
            lines.remove(0);
        }
        return result;
    }

    protected static int getIndentation(String s) {
        int result = 0;
        for (int i = 0; i < s.length() && s.charAt(i) == '\t'; ++i) {
            ++result;
        }
        return result;
    }

    protected static ArrayList linesToNested(List<String> lines, int[] index, int[] levels, int offset) {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        int level = levels[index[0]];
        while (lines.size() > index[0]) {
            if (levels[index[0]] == level) {
                result.add(new Line(offset + index[0], lines.get(index[0]).substring(level)));
                index[0] = index[0] + 1;
                continue;
            }
            if (levels[index[0]] > level) {
                result.add(NestedFormatHelper.linesToNested(lines, index, levels, offset));
                continue;
            }
            if (levels[index[0]] >= level) continue;
            break;
        }
        return result;
    }

    public static ArrayList linesToNested(List<String> lines) {
        return NestedFormatHelper.linesToNested(lines, 0);
    }

    public static ArrayList linesToNested(List<String> lines, int offset) {
        int[] levels = new int[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            levels[i] = NestedFormatHelper.getIndentation(lines.get(i));
        }
        ArrayList result = NestedFormatHelper.linesToNested(lines, new int[]{0}, levels, offset);
        return result;
    }

    protected static String getIndentation(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append("\t");
        }
        return result.toString();
    }

    protected static void nestedToLines(List nested, boolean lineNo, List<String> lines, int level) {
        for (int i = 0; i < nested.size(); ++i) {
            if (nested.get(i).getClass() == Line.class) {
                Line line = (Line)nested.get(i);
                lines.add((lineNo ? line.getNumber() + 1 + ":" : "") + NestedFormatHelper.getIndentation(level) + line.getContent());
                continue;
            }
            NestedFormatHelper.nestedToLines((List)nested.get(i), lineNo, lines, level + 1);
        }
    }

    public static List<String> nestedToLines(List nested) {
        return NestedFormatHelper.nestedToLines(nested, false);
    }

    public static List<String> nestedToLines(List nested, boolean lineNo) {
        ArrayList<String> result = new ArrayList<String>();
        NestedFormatHelper.nestedToLines(nested, lineNo, result, 0);
        return result;
    }

    protected static int renumber(List nested, int offset) {
        int line = offset;
        for (int index = 0; index < nested.size(); ++index) {
            if (nested.get(index) instanceof ArrayList) {
                line = NestedFormatHelper.renumber((ArrayList)nested.get(index), line);
                continue;
            }
            ((Line)nested.get(index)).setNumber(line);
            ++line;
        }
        return line;
    }

    public static void renumber(List nested) {
        NestedFormatHelper.renumber(nested, 0);
    }

    public static class Line
    implements Serializable {
        private static final long serialVersionUID = -4533183619132165184L;
        protected int m_Number;
        protected String m_Content;

        public Line(String content) {
            this(-1, content);
        }

        public Line(int number, String content) {
            this.m_Number = number;
            this.m_Content = content;
        }

        public void setNumber(int value) {
            this.m_Number = value;
        }

        public int getNumber() {
            return this.m_Number;
        }

        public String getContent() {
            return this.m_Content;
        }

        public String toString() {
            return this.m_Content;
        }
    }
}

