/*
 * Decompiled with CFR 0.152.
 */
package adams.data.autocorrelation;

import adams.core.License;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.data.autocorrelation.AbstractAutoCorrelation;
import adams.data.utils.AutoCorrelation;

@MixedCopyright(author="Gene - http://stackoverflow.com/users/1161878/gene", license=License.CC_BY_SA_3, url="http://stackoverflow.com/a/12453487/4698227")
public class BruteForce
extends AbstractAutoCorrelation
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -1755202230101364960L;

    @Override
    public String globalInfo() {
        return "Uses brute force approach to autocorrelation.\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return AutoCorrelation.getTechnicalInformation();
    }

    @Override
    protected void check(double[] data) {
        super.check(data);
        if (data.length % 2 != 0) {
            throw new IllegalStateException("Length of signal array must be even, provided: " + data.length);
        }
    }

    @Override
    protected double[] doCorrelate(double[] data) {
        return AutoCorrelation.bruteForce(data);
    }
}

