/*
 * Decompiled with CFR 0.152.
 */
package adams.data.autocorrelation;

import adams.core.License;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.annotation.MixedCopyright;
import adams.data.autocorrelation.AbstractAutoCorrelation;
import adams.data.utils.AutoCorrelation;

@MixedCopyright(author="Gene - http://stackoverflow.com/users/1161878/gene", license=License.CC_BY_SA_3, url="http://stackoverflow.com/a/12453487/4698227")
public class FFT
extends AbstractAutoCorrelation
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 3413225445542399689L;
    protected boolean m_Normalize;

    @Override
    public String globalInfo() {
        return "Uses FFT approach to autocorrelation.\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("normalize", "normalize", false);
    }

    public void setNormalize(boolean value) {
        this.m_Normalize = value;
        this.reset();
    }

    public boolean getNormalize() {
        return this.m_Normalize;
    }

    public String normalizeTipText() {
        return "Whether to normalize the data.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return AutoCorrelation.getTechnicalInformation();
    }

    @Override
    protected void check(double[] data) {
        super.check(data);
        if (data.length % 2 != 0) {
            throw new IllegalStateException("Length of signal array must be even, provided: " + data.length);
        }
    }

    @Override
    protected double[] doCorrelate(double[] data) {
        return AutoCorrelation.fft(data, this.m_Normalize);
    }
}

