/*
 * Decompiled with CFR 0.152.
 */
package adams.data.container;

import adams.core.CloneHandler;
import adams.data.MutableNotesHandler;
import adams.data.Notes;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import java.io.Serializable;

public abstract class AbstractSimpleContainer<T>
implements Serializable,
CloneHandler<AbstractSimpleContainer<T>>,
MutableNotesHandler,
MutableReportHandler<Report> {
    private static final long serialVersionUID = -7088299534737380639L;
    public static final String FIELD_FILENAME = "Filename";
    protected T m_Content;
    protected Report m_Report;
    protected Notes m_Notes;

    protected AbstractSimpleContainer() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Content = null;
        this.m_Notes = new Notes();
        this.m_Report = new Report();
        this.m_Report.addField(new Field(FIELD_FILENAME, DataType.STRING));
    }

    protected abstract T cloneContent();

    @Override
    public AbstractSimpleContainer<T> getClone() {
        AbstractSimpleContainer<T> result = this.getHeader();
        result.setContent(this.cloneContent());
        return result;
    }

    public AbstractSimpleContainer<T> getHeader() {
        AbstractSimpleContainer result;
        try {
            result = (AbstractSimpleContainer)this.getClass().newInstance();
            result.setReport(this.getReport().getClone());
            result.m_Notes = this.getNotes().getClone();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public void setContent(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Null content provided!");
        }
        this.m_Content = value;
    }

    public T getContent() {
        return this.m_Content;
    }

    @Override
    public boolean hasReport() {
        return this.m_Report != null;
    }

    @Override
    public void setReport(Report value) {
        this.m_Report = value;
    }

    @Override
    public Report getReport() {
        return this.m_Report;
    }

    public void setNotes(Notes value) {
        this.m_Notes = value;
    }

    @Override
    public Notes getNotes() {
        return this.m_Notes;
    }

    public String toString() {
        return "content=" + this.m_Content + ", report=" + this.m_Report + ", notes=" + this.m_Notes;
    }
}

