/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractStringConversion;

public class BreakUpString
extends AbstractStringConversion {
    private static final long serialVersionUID = 6233539723999989507L;
    protected int m_NumColumns;

    @Override
    public String globalInfo() {
        return "Breaks up a string into multiple lines if wider than the specified number of columns. Uses word-boundaries.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-columns", "numColumns", 72, 1, null);
    }

    public void setNumColumns(int value) {
        this.m_NumColumns = value;
        this.reset();
    }

    public int getNumColumns() {
        return this.m_NumColumns;
    }

    public String numColumnsTipText() {
        return "The maximum number of columns (ie characters) of the generated string.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "numColumns", this.m_NumColumns);
    }

    @Override
    protected Object doConvert() throws Exception {
        return Utils.flatten(Utils.breakUp((String)this.m_Input, this.m_NumColumns), "\n");
    }
}

