/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import java.util.Properties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class DOMToProperties
extends AbstractConversion {
    private static final long serialVersionUID = 6744245717394758406L;
    protected String m_PathSeparator;
    protected boolean m_AddIndex;
    protected boolean m_StoreAttributes;
    protected boolean m_SkipRoot;

    @Override
    public String globalInfo() {
        return "Flattens a DOM object (or node) into a Properties object.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path-separator", "pathSeparator", ".");
        this.m_OptionManager.add("add-index", "addIndex", false);
        this.m_OptionManager.add("store-attributes", "storeAttributes", false);
        this.m_OptionManager.add("skip-root", "skipRoot", false);
    }

    public void setPathSeparator(String value) {
        this.m_PathSeparator = value;
        this.reset();
    }

    public String getPathSeparator() {
        return this.m_PathSeparator;
    }

    public String pathSeparatorTipText() {
        return "The separator to use in the path.";
    }

    public void setAddIndex(boolean value) {
        this.m_AddIndex = value;
        this.reset();
    }

    public boolean getAddIndex() {
        return this.m_AddIndex;
    }

    public String addIndexTipText() {
        return "If enabled, the index gets added to the path, to disambiguate.";
    }

    public void setStoreAttributes(boolean value) {
        this.m_StoreAttributes = value;
        this.reset();
    }

    public boolean getStoreAttributes() {
        return this.m_StoreAttributes;
    }

    public String storeAttributesTipText() {
        return "If enabled, attribute values get stored as well.";
    }

    public void setSkipRoot(boolean value) {
        this.m_SkipRoot = value;
        this.reset();
    }

    public boolean getSkipRoot() {
        return this.m_SkipRoot;
    }

    public String skipRootTipText() {
        return "If enabled, the root element name is excluded from the path.";
    }

    @Override
    public Class accepts() {
        return Node.class;
    }

    @Override
    public Class generates() {
        return Properties.class;
    }

    protected boolean hasTextContent(Node node) {
        boolean result = node.getChildNodes().getLength() > 0;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            if (node.getChildNodes().item(i).getNodeType() == 3) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean flatten(String path, Node node, int index, adams.core.Properties props) {
        int i;
        if (node.getNodeType() == 3) {
            return false;
        }
        if (path == null) {
            path = this.m_SkipRoot ? "" : node.getNodeName();
        } else {
            if (path.length() > 0) {
                path = path + this.m_PathSeparator;
            }
            path = path + (this.m_AddIndex ? "[" + (index + 1) + "]-" : "") + node.getNodeName();
        }
        if (this.hasTextContent(node)) {
            try {
                String content = node.getTextContent();
                if (content != null) {
                    props.setProperty(path, content);
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (this.m_StoreAttributes && node.hasAttributes()) {
            for (i = 0; i < node.getAttributes().getLength(); ++i) {
                props.setProperty(path + this.m_PathSeparator + node.getAttributes().item(i).getNodeName(), node.getAttributes().item(i).getNodeValue());
            }
        }
        int count = 0;
        for (i = 0; i < node.getChildNodes().getLength(); ++i) {
            if (!this.flatten(path, node.getChildNodes().item(i), count, props)) continue;
            ++count;
        }
        return true;
    }

    @Override
    protected Object doConvert() throws Exception {
        adams.core.Properties result = new adams.core.Properties();
        this.flatten(null, (Node)this.m_Input, 0, result);
        return result;
    }
}

