/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.management.LocaleHelper;
import adams.core.management.OptionHandlingLocaleSupporter;
import adams.data.conversion.AbstractStringConversion;
import java.util.Locale;

public class LowerCase
extends AbstractStringConversion
implements OptionHandlingLocaleSupporter {
    private static final long serialVersionUID = -4017583319699378889L;
    protected Locale m_Locale;

    @Override
    public String globalInfo() {
        return "Turns a String into a lowercase String.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("locale", "locale", LocaleHelper.getSingleton().getDefault());
    }

    @Override
    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    @Override
    public Locale getLocale() {
        return this.m_Locale;
    }

    @Override
    public String localeTipText() {
        return "The locale setting to use for the string conversion.";
    }

    @Override
    protected Object doConvert() throws Exception {
        return ((String)this.m_Input).toLowerCase(this.m_Locale);
    }
}

