/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DiffUtils;
import adams.core.Utils;
import adams.data.conversion.AbstractConversionToString;

public class SideBySideDiffToString
extends AbstractConversionToString {
    private static final long serialVersionUID = -3431292077368307264L;
    protected String m_Separator;

    @Override
    public String globalInfo() {
        return "Turns a side-by-side diff object into a string.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separator", "separator", Utils.backQuoteChars(" | "));
    }

    public void setSeparator(String value) {
        this.m_Separator = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getSeparator() {
        return Utils.backQuoteChars(this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator to use between the columns; tab can be entered as '\\t'.";
    }

    @Override
    public Class accepts() {
        return DiffUtils.SideBySideDiff.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        return ((DiffUtils.SideBySideDiff)this.m_Input).toString(this.m_Separator);
    }
}

