/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.ClassCrossReference;
import adams.core.Constants;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractStringConversion;
import adams.data.conversion.BackQuote;
import adams.data.conversion.Quote;
import adams.data.conversion.UnBackQuote;
import java.util.ArrayList;

public class UnQuote
extends AbstractStringConversion
implements ClassCrossReference {
    private static final long serialVersionUID = -1362461206623476937L;
    protected Quote.QuoteType m_QuoteType;
    protected boolean m_DoubleUp;

    @Override
    public String globalInfo() {
        return "Removes the quotes (single or double) surrounding a string. Also unbackquotes new lines and tabs.";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{Quote.class, BackQuote.class, UnBackQuote.class};
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("quote-type", "quoteType", (Object)Quote.QuoteType.DOUBLE);
        this.m_OptionManager.add("double-up", "doubleUp", false);
    }

    public void setQuoteType(Quote.QuoteType value) {
        this.m_QuoteType = value;
        this.reset();
    }

    public Quote.QuoteType getQuoteType() {
        return this.m_QuoteType;
    }

    public String quoteTypeTipText() {
        return "The type of quote to use.";
    }

    public void setDoubleUp(boolean value) {
        this.m_DoubleUp = value;
        this.reset();
    }

    public boolean getDoubleUp() {
        return this.m_DoubleUp;
    }

    public String doubleUpTipText() {
        return "If enabled, internal quotes get un-doubled up rather than un-escaped with backslashes.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "quoteType", (Object)this.m_QuoteType, "type: ");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "doubleUp", this.m_DoubleUp, "double-up"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    protected Object doConvert() throws Exception {
        String result;
        String input = (String)this.m_Input;
        switch (this.m_QuoteType) {
            case DOUBLE: {
                if (this.m_DoubleUp) {
                    result = Utils.unDoubleUpQuotes(input, '\"', Constants.BACKQUOTED_STRINGS, Constants.BACKQUOTE_CHARS);
                    break;
                }
                result = Utils.unDoubleQuote(input);
                break;
            }
            case SINGLE: {
                if (this.m_DoubleUp) {
                    result = Utils.unDoubleUpQuotes(input, '\'', Constants.BACKQUOTED_STRINGS, Constants.BACKQUOTE_CHARS);
                    break;
                }
                result = Utils.unquote(input);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled quote type: " + (Object)((Object)this.m_QuoteType));
            }
        }
        return result;
    }
}

