/*
 * Decompiled with CFR 0.152.
 */
package adams.data.distribution;

import adams.data.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.CauchyDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class Cauchy
extends AbstractRealDistribution {
    private static final long serialVersionUID = -1708992443868275973L;
    protected double m_Median;
    protected double m_Scale;

    @Override
    public String globalInfo() {
        return "The Cauchy distribution.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("median", "median", 0.0);
        this.m_OptionManager.add("scale", "scale", 1.0);
    }

    public void setMedian(double value) {
        this.m_Median = value;
        this.reset();
    }

    public double getMedian() {
        return this.m_Median;
    }

    public String medianTipText() {
        return "The median parameter.";
    }

    public void setScale(double value) {
        this.m_Scale = value;
        this.reset();
    }

    public double getScale() {
        return this.m_Scale;
    }

    public String scaleTipText() {
        return "The scale parameter.";
    }

    @Override
    public RealDistribution getRealDistribution() {
        return new CauchyDistribution(this.m_Median, this.m_Scale);
    }
}

