/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.JAIImageWriter;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class JAIImageReader
extends AbstractImageReader<BufferedImageContainer> {
    private static final long serialVersionUID = 8416312222136406140L;
    protected String[] m_FormatExtensions;

    @Override
    public String globalInfo() {
        return "Java Advanced Imaging (JAI) image reader for: " + Utils.flatten(this.getFormatExtensions(), ", ");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FormatExtensions = ImageIO.getReaderFileSuffixes();
    }

    @Override
    public String getFormatDescription() {
        return "JAI";
    }

    @Override
    public String[] getFormatExtensions() {
        return this.m_FormatExtensions;
    }

    @Override
    public AbstractImageWriter getCorrespondingWriter() {
        return new JAIImageWriter();
    }

    public ImageReader getReader() {
        return BufferedImageHelper.getReaderForExtension(this.getDefaultFormatExtension());
    }

    @Override
    protected BufferedImageContainer doRead(PlaceholderFile file) {
        return BufferedImageHelper.read(file);
    }
}

