/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.data.io.input.AbstractTextReaderWithEncoding;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;

public class LineByLineTextReader
extends AbstractTextReaderWithEncoding<String> {
    private static final long serialVersionUID = -2921085514028198744L;
    protected transient Scanner m_Scanner;

    @Override
    public String globalInfo() {
        return "Reads the text data, line by line. Allows the reading of very large files.";
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    public void initialize(InputStream stream) {
        super.initialize(stream);
        this.m_Scanner = new Scanner(this.m_Stream, this.m_Encoding.charsetValue().name());
    }

    @Override
    protected String doNext() {
        String result = null;
        try {
            result = this.m_Scanner.nextLine();
        }
        catch (NoSuchElementException e) {
            this.m_Scanner.close();
            this.m_Scanner = null;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read from scanner!", e);
            this.m_Scanner.close();
            this.m_Scanner = null;
            result = null;
        }
        if (this.m_Scanner == null) {
            this.m_Stream = null;
        }
        return result;
    }
}

