/*
 * Decompiled with CFR 0.152.
 */
package adams.data.padding;

import adams.data.padding.PaddingType;

public class PaddingHelper {
    public static int nextPowerOf2(int n) {
        int exp = (int)StrictMath.ceil(StrictMath.log(n) / StrictMath.log(2.0));
        exp = StrictMath.max(2, exp);
        return (int)StrictMath.pow(2.0, exp);
    }

    public static float[] padPow2(float[] data, PaddingType type) {
        return PaddingHelper.pad(data, PaddingHelper.nextPowerOf2(data.length), type);
    }

    public static float[] padPow2(float[] data, PaddingType type, boolean padLeft) {
        return PaddingHelper.pad(data, PaddingHelper.nextPowerOf2(data.length), type, padLeft);
    }

    public static float[] pad(float[] data, int numPoints, PaddingType type) {
        return PaddingHelper.pad(data, numPoints, type, false);
    }

    public static float[] pad(float[] data, int numPoints, PaddingType type, boolean padLeft) {
        float[] result;
        block14: {
            block13: {
                if (numPoints < data.length) {
                    throw new IllegalArgumentException("Number of output data points is smaller than input data points: " + numPoints + " < " + data.length);
                }
                result = new float[numPoints];
                if (!padLeft) break block13;
                System.arraycopy(data, 0, result, result.length - data.length, data.length);
                switch (type) {
                    case ZERO: {
                        for (int i = 0; i < result.length - data.length; ++i) {
                            result[i] = 0.0f;
                        }
                        break block14;
                    }
                    case LAST: {
                        for (int i = 0; i < result.length - data.length; ++i) {
                            result[i] = result[result.length - data.length];
                        }
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException("Padding " + type + " not implemented!");
                    }
                }
            }
            System.arraycopy(data, 0, result, 0, data.length);
            switch (type) {
                case ZERO: {
                    for (int i = data.length; i < numPoints; ++i) {
                        result[i] = 0.0f;
                    }
                    break;
                }
                case LAST: {
                    for (int i = data.length; i < numPoints; ++i) {
                        result[i] = result[data.length - 1];
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Padding " + type + " not implemented!");
                }
            }
        }
        return result;
    }

    public static double[] padPow2(double[] data, PaddingType type) {
        return PaddingHelper.pad(data, PaddingHelper.nextPowerOf2(data.length), type);
    }

    public static double[] padPow2(double[] data, PaddingType type, boolean padLeft) {
        return PaddingHelper.pad(data, PaddingHelper.nextPowerOf2(data.length), type, padLeft);
    }

    public static double[] pad(double[] data, int numPoints, PaddingType type) {
        return PaddingHelper.pad(data, numPoints, type, false);
    }

    public static double[] pad(double[] data, int numPoints, PaddingType type, boolean padLeft) {
        double[] result;
        block14: {
            block13: {
                if (numPoints < data.length) {
                    throw new IllegalArgumentException("Number of output data points is smaller than input data points: " + numPoints + " < " + data.length);
                }
                result = new double[numPoints];
                if (!padLeft) break block13;
                System.arraycopy(data, 0, result, result.length - data.length, data.length);
                switch (type) {
                    case ZERO: {
                        for (int i = 0; i < result.length - data.length; ++i) {
                            result[i] = 0.0;
                        }
                        break block14;
                    }
                    case LAST: {
                        for (int i = 0; i < result.length - data.length; ++i) {
                            result[i] = result[result.length - data.length];
                        }
                        break block14;
                    }
                    default: {
                        throw new IllegalStateException("Padding " + type + " not implemented!");
                    }
                }
            }
            System.arraycopy(data, 0, result, 0, data.length);
            switch (type) {
                case ZERO: {
                    for (int i = data.length; i < numPoints; ++i) {
                        result[i] = 0.0;
                    }
                    break;
                }
                case LAST: {
                    for (int i = data.length; i < numPoints; ++i) {
                        result[i] = result[data.length - 1];
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Padding " + type + " not implemented!");
                }
            }
        }
        return result;
    }
}

