/*
 * Decompiled with CFR 0.152.
 */
package adams.data.smoothing;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.Performance;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSmoother<T extends DataContainer>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractSmoother> {
    private static final long serialVersionUID = 5504652439909198344L;

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public T smooth(T data) {
        this.checkData(data);
        T result = this.processData(data);
        result.setID(data.getID() + "'");
        if (result instanceof NotesHandler) {
            ((NotesHandler)result).getNotes().addProcessInformation(this);
        }
        return result;
    }

    protected void checkData(T data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected abstract T processData(T var1);

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractSmoother shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractSmoother shallowCopy(boolean expand) {
        return (AbstractSmoother)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getSmoothers() {
        return ClassLister.getSingleton().getClassnames(AbstractSmoother.class);
    }

    public static AbstractSmoother forName(String classname, String[] options) {
        AbstractSmoother result;
        try {
            result = (AbstractSmoother)OptionUtils.forName(AbstractSmoother.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractSmoother forCommandLine(String cmdline) {
        return (AbstractSmoother)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static DataContainer smooth(AbstractSmoother smoother, DataContainer data) {
        ArrayList<DataContainer> dataList = new ArrayList<DataContainer>();
        dataList.add(data);
        ArrayList<AbstractSmoother> smootherList = new ArrayList<AbstractSmoother>();
        smootherList.add(smoother);
        List<List<DataContainer>> smoothed = AbstractSmoother.smooth(smootherList, dataList);
        DataContainer result = smoothed.get(0).get(0);
        return result;
    }

    public static List<DataContainer> smooth(AbstractSmoother smoother, List<DataContainer> data) {
        ArrayList<DataContainer> dataList = new ArrayList<DataContainer>();
        dataList.addAll(data);
        ArrayList<AbstractSmoother> smootherList = new ArrayList<AbstractSmoother>();
        smootherList.add(smoother);
        List<List<DataContainer>> smoothed = AbstractSmoother.smooth(smootherList, dataList);
        List<DataContainer> result = smoothed.get(0);
        return result;
    }

    public static List<DataContainer> smooth(List<AbstractSmoother> smoother, DataContainer data) {
        ArrayList<DataContainer> dataList = new ArrayList<DataContainer>();
        dataList.add(data);
        ArrayList<AbstractSmoother> smootherList = new ArrayList<AbstractSmoother>();
        smootherList.addAll(smoother);
        List<List<DataContainer>> smoothed = AbstractSmoother.smooth(smootherList, dataList);
        ArrayList<DataContainer> result = new ArrayList<DataContainer>();
        for (int i = 0; i < smoothed.size(); ++i) {
            result.add(smoothed.get(i).get(0));
        }
        return result;
    }

    public static List<List<DataContainer>> smooth(List<AbstractSmoother> smoother, List<DataContainer> data) {
        ArrayList<List<DataContainer>> result = new ArrayList<List<DataContainer>>();
        if (Performance.getMultiProcessingEnabled()) {
            int i;
            JobRunner runner = new JobRunner();
            JobList<SmootherJob<DataContainer>> jobs = new JobList<SmootherJob<DataContainer>>();
            for (int n = 0; n < smoother.size(); ++n) {
                for (i = 0; i < data.size(); ++i) {
                    AbstractSmoother threadSmoother = smoother.get(n).shallowCopy(true);
                    jobs.add(new SmootherJob<DataContainer>(threadSmoother, data.get(i)));
                }
            }
            runner.add(jobs);
            runner.start();
            runner.stop();
            ArrayList<Object> subresult = null;
            for (i = 0; i < jobs.size(); ++i) {
                SmootherJob job;
                if (i % data.size() == 0) {
                    subresult = new ArrayList<Object>();
                    result.add(subresult);
                }
                if ((job = (SmootherJob)jobs.get(i)).getSmoothedData() != null) {
                    subresult.add(job.getSmoothedData());
                } else {
                    subresult.add(job.getData().getHeader());
                }
                job.cleanUp();
            }
        } else {
            for (int n = 0; n < smoother.size(); ++n) {
                ArrayList<DataContainer> subresult = new ArrayList<DataContainer>();
                result.add(subresult);
                for (int i = 0; i < data.size(); ++i) {
                    AbstractSmoother threadSmoother = smoother.get(n).shallowCopy(true);
                    subresult.add(threadSmoother.smooth(data.get(i)));
                }
            }
        }
        return result;
    }

    public static class SmootherJob<T extends DataContainer>
    extends Job {
        private static final long serialVersionUID = 5544327082749651329L;
        protected AbstractSmoother m_Smoother;
        protected T m_Data;
        protected T m_SmoothedData;

        public SmootherJob(AbstractSmoother smoother, T data) {
            this.m_Smoother = smoother;
            this.m_Data = data;
            this.m_SmoothedData = null;
        }

        public AbstractSmoother getSmoother() {
            return this.m_Smoother;
        }

        public T getData() {
            return this.m_Data;
        }

        public T getSmoothedData() {
            return this.m_SmoothedData;
        }

        @Override
        protected String preProcessCheck() {
            if (this.m_Smoother == null) {
                return "No smoothing scheme set!";
            }
            if (this.m_Data == null) {
                return "No data set!";
            }
            return null;
        }

        @Override
        protected void process() throws Exception {
            this.m_SmoothedData = this.m_Smoother.smooth(this.m_Data);
        }

        @Override
        protected String postProcessCheck() {
            if (this.m_SmoothedData == null) {
                return "Result of smoothing scheme is null!";
            }
            return null;
        }

        @Override
        public void cleanUp() {
            super.cleanUp();
            this.m_Data = null;
            this.m_Smoother.destroy();
            this.m_Smoother = null;
            this.m_SmoothedData = null;
        }

        @Override
        protected String getAdditionalErrorInformation() {
            if (this.m_Data instanceof NotesHandler) {
                return ((NotesHandler)this.m_Data).getNotes().toString();
            }
            return "";
        }

        @Override
        public String toString() {
            String result = "data:" + this.m_Data.getID() + ", ";
            if (this.m_Data instanceof DatabaseIDHandler) {
                result = result + "db-id: " + ((DatabaseIDHandler)this.m_Data).getDatabaseID() + ", ";
            }
            result = result + "smoother: " + OptionUtils.getCommandLine(this.m_Smoother);
            return result;
        }
    }
}

