/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.EqualLengthArrayStatistic;
import adams.data.statistics.StatUtils;

public abstract class AbstractArrayDistance<T extends Number>
extends AbstractArrayStatistic<T>
implements EqualLengthArrayStatistic {
    private static final long serialVersionUID = 9045810089203101126L;

    @Override
    public String globalInfo() {
        return "Calculates the " + this.getDistanceName() + " distance between the first array " + "and the remaining arrays. The arrays must be numeric, of course.";
    }

    protected abstract String getDistanceName();

    @Override
    public int getLength() {
        if (this.size() > 0) {
            return ((Number[])this.get(0)).length;
        }
        return -1;
    }

    @Override
    public int getMin() {
        return 2;
    }

    @Override
    public int getMax() {
        return -1;
    }

    protected abstract double calcDistance(double[] var1, double[] var2);

    protected String createCellHeader() {
        return this.getDistanceName() + " distance";
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, this.size() - 1);
        double[] first = StatUtils.toDoubleArray((Number[])this.get(0));
        for (int i = 1; i < this.size(); ++i) {
            double[] other = StatUtils.toDoubleArray((Number[])this.get(i));
            result.setHeader(i - 1, this.createCellHeader() + " 1-" + (i + 1));
            result.setCell(0, i - 1, this.calcDistance(first, other));
        }
        return result;
    }
}

