/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import java.io.Serializable;

public class ArrayLength<T extends Serializable>
extends AbstractArrayStatistic<T> {
    private static final long serialVersionUID = -1540382151498537227L;

    @Override
    public String globalInfo() {
        return "Determines the length of an array.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Integer> result = new AbstractArrayStatistic.StatisticContainer<Integer>(1, this.size());
        String prefix = "length";
        if (this.size() > 1) {
            prefix = prefix + "-";
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.size() > 1) {
                result.setHeader(i, prefix + (i + 1));
            } else {
                result.setHeader(i, prefix);
            }
            result.setCell(0, i, this.get(i).length);
        }
        return result;
    }
}

