/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.EqualLengthArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArrayLinearRegression<T extends Number>
extends AbstractArrayStatistic<T>
implements EqualLengthArrayStatistic {
    private static final long serialVersionUID = -5911270089583842477L;

    @Override
    public String globalInfo() {
        return "Calculates the slope and intercept of linear regression between two arrays (x and y).\nIf more than two arrays supplied, then the linear regression is computed between the first (x) and all the other ones (y).";
    }

    @Override
    public int getLength() {
        if (this.size() > 0) {
            return ((Number[])this.get(0)).length;
        }
        return -1;
    }

    @Override
    public int getMin() {
        return 2;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, (this.size() - 1) * 2);
        for (int i = 1; i < this.size(); ++i) {
            if (this.size() > 2) {
                result.setHeader((i - 1) * 2 + 0, "intercept_1-" + (i + 1));
                result.setHeader((i - 1) * 2 + 1, "slope_1-" + (i + 1));
            } else {
                result.setHeader(0, "intercept");
                result.setHeader(1, "slope");
            }
            double[] lr = StatUtils.linearRegression((Number[])this.get(0), (Number[])this.get(i));
            result.setCell(0, (i - 1) * 2 + 0, lr[0]);
            result.setCell(0, (i - 1) * 2 + 1, lr[1]);
        }
        return result;
    }
}

