/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.StatUtils;

public class ArrayMedian<T extends Number>
extends AbstractArrayStatistic<T> {
    private static final long serialVersionUID = -7003283843312806178L;

    @Override
    public String globalInfo() {
        return "Calculates the median for a numeric array.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(1, this.size());
        for (int i = 0; i < this.size(); ++i) {
            if (this.size() > 1) {
                result.setHeader(i, "median-" + (i + 1));
            } else {
                result.setHeader(i, "median");
            }
            result.setCell(0, i, StatUtils.median((Number[])this.get(i)));
        }
        return result;
    }
}

