/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import java.io.Serializable;

public class StatCalc
implements Serializable {
    private static final long serialVersionUID = 5628657151878022137L;
    private int count;
    private double sum;
    private double squareSum;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;

    public void enter(double num) {
        ++this.count;
        if (num < this.min) {
            this.min = num;
        }
        if (num > this.max) {
            this.max = num;
        }
        this.sum += num;
        this.squareSum += num * num;
    }

    public int getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public double getSumSquares() {
        return this.squareSum;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        return Math.sqrt(this.squareSum / (double)this.count - mean * mean);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public String toString() {
        return "[count=" + this.getCount() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", sum=" + this.getSum() + ", sumSq=" + this.getSumSquares() + ", mean=" + this.getMean() + ", stdev=" + this.getStandardDeviation() + "]";
    }
}

