/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.base.BasePassword;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseManager;
import adams.env.AbstractEnvironment;
import adams.env.Environment;

public class DatabaseConnection
extends AbstractDatabaseConnection {
    private static final long serialVersionUID = -3625820307854172417L;
    public static final String FILENAME = "DatabaseConnection.props";
    private static DatabaseManager<DatabaseConnection> m_DatabaseManager = new DatabaseManager("adams");

    public DatabaseConnection() {
    }

    public DatabaseConnection(String url, String user, BasePassword password) {
        super(url, user, password);
    }

    @Override
    protected AbstractEnvironment createEnvironment() {
        return new Environment();
    }

    @Override
    protected String getDefinitionKey() {
        return "database connection - adams";
    }

    public static synchronized DatabaseConnection getSingleton(String url, String user, BasePassword password) {
        if (!m_DatabaseManager.has(url, user, password)) {
            m_DatabaseManager.add(new DatabaseConnection(url, user, password));
        } else if (!m_DatabaseManager.get(url, user, password).isConnected()) {
            try {
                m_DatabaseManager.get(url, user, password).connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m_DatabaseManager.get(url, user, password);
    }

    public static synchronized DatabaseConnection getSingleton() {
        return m_DatabaseManager.getDefault();
    }

    static {
        DatabaseConnection dbcon = new DatabaseConnection();
        m_DatabaseManager.setDefault(DatabaseConnection.getSingleton(dbcon.getURL(), dbcon.getUser(), dbcon.getPassword()));
    }
}

