/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.javadoc;

import adams.core.Utils;
import adams.doc.javadoc.Javadoc;
import adams.gui.scripting.AbstractScriptlet;

public class ScriptletJavadoc
extends Javadoc {
    private static final long serialVersionUID = -3836221902854905090L;
    public static final String ACTION_STARTTAG = "<!-- scriptlet-action-start -->";
    public static final String ACTION_ENDTAG = "<!-- scriptlet-action-end -->";
    public static final String DESCRIPTION_STARTTAG = "<!-- scriptlet-description-start -->";
    public static final String DESCRIPTION_ENDTAG = "<!-- scriptlet-description-end -->";
    public static final String PARAMETERS_STARTTAG = "<!-- scriptlet-parameters-start -->";
    public static final String PARAMETERS_ENDTAG = "<!-- scriptlet-parameters-end -->";

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StartTag = new String[3];
        this.m_EndTag = new String[3];
        this.m_IsBlock = new boolean[3];
        this.m_StartTag[0] = ACTION_STARTTAG;
        this.m_EndTag[0] = ACTION_ENDTAG;
        this.m_IsBlock[0] = false;
        this.m_StartTag[1] = PARAMETERS_STARTTAG;
        this.m_EndTag[1] = PARAMETERS_ENDTAG;
        this.m_IsBlock[1] = true;
        this.m_StartTag[2] = DESCRIPTION_STARTTAG;
        this.m_EndTag[2] = DESCRIPTION_ENDTAG;
        this.m_IsBlock[2] = true;
    }

    @Override
    protected String generateJavadoc(int index) throws Exception {
        String result = "";
        if (!this.canInstantiateClass()) {
            return result;
        }
        if (!(this.getInstance() instanceof AbstractScriptlet)) {
            return result;
        }
        AbstractScriptlet scriptlet = (AbstractScriptlet)this.getInstance();
        if (this.m_StartTag[index].equals(ACTION_STARTTAG)) {
            result = this.toHTML(scriptlet.getAction());
            result = result.trim();
        }
        if (this.m_StartTag[index].equals(PARAMETERS_STARTTAG)) {
            result = "Action parameters:<br>\n<pre>   " + this.toHTML(scriptlet.getParameterDescription()) + "</pre>";
            result = result.trim() + "\n<br><br>\n";
            if (this.getUseStars()) {
                result = this.indent(result, 1, "* ");
            }
        }
        if (this.m_StartTag[index].equals(DESCRIPTION_STARTTAG)) {
            String[] lines = Utils.breakUp(scriptlet.getDescription(), 72);
            result = "Description:";
            for (int i = 0; i < lines.length; ++i) {
                result = result + "\n";
                if (i == 0) {
                    result = result + "<pre>";
                }
                result = result + "   " + this.toHTML(lines[i]);
                if (i != lines.length - 1) continue;
                result = result + "</pre>";
            }
            result = result + "\n<br><br>\n";
            if (this.getUseStars()) {
                result = this.indent(result, 1, "* ");
            }
        }
        return result;
    }

    public static void main(String[] args) {
        ScriptletJavadoc.runJavadoc(ScriptletJavadoc.class, args);
    }
}

